% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deg_rationet.R
\name{get_ratio_distribution}
\alias{get_ratio_distribution}
\title{Calculate expression ratio distribution}
\usage{
get_ratio_distribution(ref.expr.matrix, p.edge = 0.1, log.expr = FALSE,
  use.parallel = FALSE)
}
\arguments{
\item{ref.expr.matrix}{The reference expression matrix. Each row represents a gene and each column represents a sample.}

\item{p.edge}{The expected probability of edges in the expression ratio network for a normal sample.}

\item{log.expr}{Logical variable indicating whether the input expression matrix is in logarithmic scale.}

\item{use.parallel}{Logical variable indicating to use the BiocParallel package to accelerate computation.}
}
\value{
This function will return a list with the following components:
  \item{LB}{A numeric matrix with element [i,j] represents the lower quantile of expressioin ratios for gene pairs (i, j).}
  \item{NB}{A numeric vector with two elements: \code{size} and \code{mu}, 
  which are the estimated parameters of negative binomial distribution.}
  \item{p.edge}{The used input parameter \code{p.edge}.}
}
\description{
Calculate the lower and upper quantiles of expression ratios for each pair of genes,
and estimate the parameters of negative binomial distribution from reference expression data.
}
