% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_counternull_values.R
\name{find_counternull_values}
\alias{find_counternull_values}
\title{Finds counternull values}
\usage{
find_counternull_values(
  obs_pval,
  sample_data,
  extreme,
  rand_matrix,
  permutation_null_function,
  permutation_counter_function,
  low,
  high,
  test_stat,
  variable,
  iterations,
  pairs
)
}
\arguments{
\item{obs_pval}{P-value from null distribution}

\item{sample_data}{Sample data set. Data should have column indicating
exposure (1) or non exposure (0) for each group (row) that is measured. Each
measured outcome (variable) should be represented by an additional column.}

\item{extreme}{Direction which is defined as more extreme for test statistic
in distribution (0 for less or 1 for greater)}

\item{rand_matrix}{Matrix with all possible randomizations of exposure
assignment}

\item{permutation_null_function}{Function used to create permutation vector
for null distribution}

\item{permutation_counter_function}{Function used to create permutation vector
for counternull distribution}

\item{low}{Lower bound of counternull value search}

\item{high}{Upper bound of counternull value search}

\item{test_stat}{Observed test statistic. (You can use built in functions to
find various test statistics in given dataset)}

\item{variable}{Variable measured. Format: sample_data$column}

\item{iterations}{Number of unique arrangements of exposure assignments
used to generate distribution (At most the number of rows in rand_matrix)}

\item{pairs}{Number of pairs of units there are to measure in dataset
(One pair = control unit + experimental unit)}
}
\value{
Vector of Counternull Values (Numeric 0 if none are found)
}
\description{
Finds and prints full range of counternull values, the test statistic
and  p-value along with null and counternull distribution if counternull
values are found. Otherwise only null distribution is displayed.
Observed test statistic is indicated in distribution using dashed
black line. No effect is indicated with gray dashed line. Counternull
value is indicated with red dashed line. Counternull values are
returned if found. 0 is returned otherwise.
}
\examples{
\donttest{
find_counternull_values(.375,sample_district_1DS,0,rand_matrix_1DS,
permutation_null_diff_means,permutation_counter_diff_means,
-8000,0, find_test_stat_diff_means(sample_district_1DS,
sample_district_1DS$charge_prosecuted_1000_rate_post -
sample_district_1DS$charge_prosecuted_1000_rate_pre),
sample_district_1DS$charge_prosecuted_1000_rate_post-
sample_district_1DS$charge_prosecuted_1000_rate_pre,128,7)

find_counternull_values(.375,sample_district_1DS,0,rand_matrix_1DS,
permutation_null_t,permutation_counter_t,
-8000,0, find_test_stat_t(sample_district_1DS,
sample_district_1DS$charge_prosecuted_1000_rate_post -
sample_district_1DS$charge_prosecuted_1000_rate_pre),
sample_district_1DS$charge_prosecuted_1000_rate_post-
sample_district_1DS$charge_prosecuted_1000_rate_pre,128,7)

find_counternull_values(.375,sample_district_1DS,0,rand_matrix_1DS,
permutation_null_paired_t,permutation_counter_paired_t,
-8000,0, find_test_stat_paired_t(sample_district_1DS,
sample_district_1DS$charge_prosecuted_1000_rate_post -
sample_district_1DS$charge_prosecuted_1000_rate_pre),
sample_district_1DS$charge_prosecuted_1000_rate_post-
sample_district_1DS$charge_prosecuted_1000_rate_pre,128,7)
}
}
