% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--data_prep--calculated_tools--date_vector_difference.R
\name{date_distance_remove}
\alias{date_distance_remove}
\title{remove distances above threshold}
\usage{
date_distance_remove(DF, vecNames, thresh)
}
\arguments{
\item{DF}{source dataframe}

\item{vecNames}{column names in DF to be modified}

\item{thresh}{max distance not removed from data}
}
\value{
DF with distances above threshold removed
}
\description{
remove distances above threshold
}
\examples{
data("Example_data", package = "Covid19Wastewater")
Example_data$Late_date <- sample(Example_data$date)
Example_data$Late_date[sample(1:length(Example_data), length(Example_data) / 3)] <- NA
df <- date_distance_calc(Example_data, "date", "Late_date")
date_distance_remove(df, "Late_date", 21)
}
