% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{save_ggplot_lst}
\alias{save_ggplot_lst}
\title{save_ggplot_lst}
\usage{
save_ggplot_lst(
  lst_plots,
  folder,
  prefix = NULL,
  suffix = NULL,
  wide = TRUE,
  quality = "4K",
  dpi = 80,
  custom = NULL,
  object_name = NULL
)
}
\arguments{
\item{lst_plots}{List of 'ggplot2'.}

\item{folder}{Character. Folder path as character type.}

\item{prefix}{Character. Prefix for file name.}

\item{suffix}{Character. Sufix for file name.}

\item{wide}{Logical. If TRUE, widescreen format (16:9) is used, in other case (4:3) format.}

\item{quality}{Character. One of: "HD", "FHD", "2K", "4K", "8K"}

\item{dpi}{Numeric. Dpi value for the image.}

\item{custom}{Numeric vector. Custom size of the image. Numeric vector of width and height.}

\item{object_name}{Character. If the file to plot it is inside of a list, name of the object to save.}
}
\value{
Generate a plot image in the specific folder or working directory.
}
\description{
Allows to save a list of 'ggplot2' objects in .tiff format based on an specific resolution.
}
\examples{
\donttest{
if(requireNamespace("ggplot2", quietly = TRUE)){
library(ggplot2)
data(iris)
g <- ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species))
g <- g + geom_point(size = 4)
g2 <- ggplot(iris, aes(Petal.Width, Petal.Length, color = Species))
g2 <- g2 + geom_point(size = 4)
lst_plots <- list("Sepal" = g, "Petal" = g2)
save_ggplot_lst(lst_plots, folder = tempdir())
}
}
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
