% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_events}
\alias{plot_events}
\title{plot_events}
\usage{
plot_events(
  Y,
  max.breaks = 20,
  roundTo = 0.1,
  categories = c("Censored", "Death"),
  y.text = "Number of observations",
  verbose = FALSE
)
}
\arguments{
\item{Y}{Numeric matrix or data.frame. Response variables. Object must have two columns named as
"time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for censored and
event observations.}

\item{max.breaks}{Numeric. Maximum number of breaks in X axis (default: 20).}

\item{roundTo}{Numeric. Value to round time. If roundTo = 0.1, the results will be rounded to the
tenths (default: 0.1).}

\item{categories}{Character vector. Vector of length two to name both categories for censored and
non-censored observations (default: c("Censored","Death")).}

\item{y.text}{Character. Y axis title (default: "Number of observations").}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}
}
\value{
A list of two elements.
\code{plot}: Barplot.
\code{df}: Data.frame used for the plotting.
}
\description{
Generates a bar plot visualizing the distribution of events over time, categorizing
observations as either censored or non-censored.
}
\details{
The \code{plot_events} function is meticulously crafted to provide a visualization of event
occurrences over a specified time frame. The primary objective of this function is to elucidate
the distribution of events, distinguishing between censored and non-censored observations. The
input response matrix, "Y", is expected to encompass two pivotal columns: "time" and "event".
The "time" column delineates the temporal occurrence of each observation, while the "event"
column demarcates whether an observation is censored or an event, with accepted binary
representations being 0/1 or FALSE/TRUE.

The function employs a systematic approach to categorize the time variable into distinct intervals
or "breaks". The number of these intervals is determined by the "max.breaks" parameter, and their
size is influenced by the "roundTo" parameter. Each interval represents a range of time values,
and the resulting plot showcases the number of censored and non-censored observations within each
interval. The bars in the plot are color-coded based on the event type, offering a clear visual
distinction between the two categories.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
Y_train <- Y_proteomic
plot_events(Y_train, categories = c("Censored","Death"))
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
