% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_sb_splsdrcox_dynamic.R
\name{sb.splsdrcox}
\alias{sb.splsdrcox}
\title{SB.sPLS-DRCOX-Dynamic}
\usage{
sb.splsdrcox(
  X,
  Y,
  n.comp = 4,
  vector = NULL,
  MIN_NVAR = 10,
  MAX_NVAR = NULL,
  n.cut_points = 5,
  MIN_AUC_INCREASE = 0.01,
  x.center = TRUE,
  x.scale = FALSE,
  remove_near_zero_variance = TRUE,
  remove_zero_variance = TRUE,
  toKeep.zv = NULL,
  remove_non_significant = FALSE,
  alpha = 0.05,
  EVAL_METHOD = "AUC",
  pred.method = "cenROC",
  max.iter = 200,
  times = NULL,
  max_time_points = 15,
  MIN_EPV = 5,
  returnData = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{X}{List of numeric matrices or data.frames. Explanatory variables. Qualitative variables must be
transform into binary variables.}

\item{Y}{Numeric matrix or data.frame. Response variables. Object must have two columns named as
"time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for censored and
event observations.}

\item{n.comp}{Numeric. Number of latent components to compute for the (s)PLS model (default: 10).}

\item{vector}{Numeric vector. Used for computing best number of variables. As many values as
components have to be provided. If vector = NULL, an automatic detection is perform (default: NULL).}

\item{MIN_NVAR}{Numeric. Minimum range size for computing cut points to select the best number of
variables to use (default: 10).}

\item{MAX_NVAR}{Numeric. Maximum range size for computing cut points to select the best number of
variables to use (default: 1000).}

\item{n.cut_points}{Numeric. Number of cut points for searching the optimal number of variables.
If only two cut points are selected, minimum and maximum size are used. For MB approaches as many
as n.cut_points^n.blocks models will be computed as minimum (default: 5).}

\item{MIN_AUC_INCREASE}{Numeric. Minimum improvement between different cross validation models to
continue evaluating higher values in the multiple tested parameters. If it is not reached for next
'MIN_COMP_TO_CHECK' models and the minimum 'MIN_AUC' value is reached, the evaluation stops
(default: 0.01).}

\item{x.center}{Logical. If x.center = TRUE, X matrix is centered to zero means (default: TRUE).}

\item{x.scale}{Logical. If x.scale = TRUE, X matrix is scaled to unit variances (default: FALSE).}

\item{remove_near_zero_variance}{Logical. If remove_near_zero_variance = TRUE, near zero variance
variables will be removed (default: TRUE).}

\item{remove_zero_variance}{Logical. If remove_zero_variance = TRUE, zero variance variables will
be removed (default: TRUE).}

\item{toKeep.zv}{Character vector. Name of variables in X to not be deleted by (near) zero variance
filtering (default: NULL).}

\item{remove_non_significant}{Logical. If remove_non_significant = TRUE, non-significant
variables/components in final cox model will be removed until all variables are significant by
forward selection (default: FALSE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the
threshold (default: 0.05).}

\item{EVAL_METHOD}{Character. The selected metric will be use to compute the best
number of variables. Must be one of the following: "AUC", "BRIER" or "c_index" (default: "AUC").}

\item{pred.method}{Character. AUC evaluation algorithm method for evaluate the model performance.
Must be one of the following: "risksetROC", "survivalROC", "cenROC", "nsROC", "smoothROCtime_C",
"smoothROCtime_I" (default: "cenROC").}

\item{max.iter}{Numeric. Maximum number of iterations for PLS convergence (default: 200).}

\item{times}{Numeric vector. Time points where the AUC will be evaluated. If NULL, a maximum of
'max_time_points' points will be selected equally distributed (default: NULL).}

\item{max_time_points}{Numeric. Maximum number of time points to use for evaluating the model
(default: 15).}

\item{MIN_EPV}{Numeric. Minimum number of Events Per Variable (EPV) you want reach for the final
cox model. Used to restrict the number of variables/components can be computed in final cox models.
If the minimum is not meet, the model cannot be computed (default: 5).}

\item{returnData}{Logical. Return original and normalized X and Y matrices (default: TRUE).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}
}
\value{
Instance of class "Coxmos" and model "sb.splscox". The class contains the following
elements:
\code{X}: List of normalized X data information.
\itemize{
\item \code{(data)}: normalized X matrix
\item \code{(weightings)}: PLS weights
\item \code{(weightings_norm)}: PLS normalize weights
\item \code{(W.star)}: PLS W* vector
\item \code{(scores)}: PLS scores/variates
\item \code{(x.mean)}: mean values for X matrix
\item \code{(x.sd)}: standard deviation for X matrix
}
\code{Y}: List of normalized Y data information.
\itemize{
\item \code{(deviance_residuals)}: deviance residual vector used as Y matrix in the sPLS.
\item \code{(dr.mean)}: mean values for deviance residuals Y matrix
\item \code{(dr.sd)}: standard deviation for deviance residuals Y matrix'
\item \code{(data)}: normalized X matrix
\item \code{(y.mean)}: mean values for Y matrix
\item \code{(y.sd)}: standard deviation for Y matrix'
}
\code{survival_model}: List of survival model information.
\itemize{
\item \code{fit}: coxph object.
\item \code{AIC}: AIC of cox model.
\item \code{BIC}: BIC of cox model.
\item \code{lp}: linear predictors for train data.
\item \code{coef}: Coefficients for cox model.
\item \code{YChapeau}: Y Chapeau residuals.
\item \code{Yresidus}: Y residuals.
}

\code{list_spls_models}: List of sPLS-DRCOX models computed for each block.

\code{n.comp}: Number of components selected.

\code{penalty} Penalty applied.

\code{call}: call function

\code{X_input}: X input matrix

\code{Y_input}: Y input matrix

\code{nzv}: Variables removed by remove_near_zero_variance or remove_zero_variance.

\code{nz_coeffvar}: Variables removed by coefficient variation near zero.

\code{class}: Model class.

\code{time}: time consumed for running the cox analysis.
}
\description{
This function performs a single-block sparse partial least squares deviance residual
Cox (SB.sPLS-DRCOX-Dynamic). The function returns a Coxmos model with the attribute model as "SB.sPLS-DRCOX-Dynamic".
}
\details{
The \code{SB.sPLS-DRCOX-Dynamic} function performs a single-block sparse partial least squares deviance residual
Cox analysis. This method is designed to handle datasets with a single block of explanatory variables
and aims to identify the most relevant features that contribute to the survival outcome. The method
combines the strengths of sparse partial least squares (sPLS) with Cox regression, allowing for
dimensionality reduction, feature selection, and survival analysis in a unified framework.

The key feature of this function is the use of deviance residuals as the response in the sPLS model.
Deviance residuals are derived from a preliminary Cox model and capture the discrepancies between
the observed and expected number of events. By using these residuals as the response, the sPLS model
can focus on identifying the explanatory variables that have the most significant impact on the
survival outcome.

The function offers flexibility in specifying various hyperparameters, such as the number of latent
components (\code{n.comp}) and the penalty for variable selection (\code{penalty}). The penalty parameter, \code{penalty},
controls the sparsity of the model, with higher values leading to more variables being excluded from
the model. This allows for a balance between model complexity and interpretability.

Data preprocessing options, such as centering and scaling of the explanatory variables and removal
of near-zero variance variables, are also provided. These preprocessing steps ensure that the data
is in a suitable format for the sPLS model and can help improve the stability and performance of
the analysis.

The output of the function provides a comprehensive overview of the sPLS-DRCOX model, including the
normalized data, PLS weights and scores, and the final Cox model. Visualization tools and metrics
such as AIC and BIC are also provided to aid in understanding the model's performance and
significance of the selected features.

In summary, the \code{SB.sPLS-DRCOX-Dynamic} function offers a robust approach for survival analysis with
high-dimensional data, combining feature selection, dimensionality reduction, and Cox regression
in a single-block framework. The method is particularly useful for datasets where the number of
variables exceeds the number of observations, and there's a need to identify the most relevant
features for predicting survival outcomes.
}
\examples{
data("X_multiomic")
data("Y_multiomic")
X <- X_multiomic
set.seed(123)
index_train <- caret::createDataPartition(Y_multiomic$event, p = .25, list = FALSE, times = 1)
X_train <- X_multiomic
X_train$mirna <- X_train$mirna[index_train,1:30]
X_train$proteomic <- X_train$proteomic[index_train,1:30]
Y_train <- Y_multiomic[index_train,]
Y <- Y_multiomic
sb.splsdrcox(X_train, Y_train, n.comp = 2, vector = NULL, x.center = TRUE, x.scale = TRUE)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
