% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModSim.R
\name{ModSim}
\alias{ModSim}
\title{Function to simulate a dataset.}
\usage{
ModSim(Lbd, Pi, eta, N)
}
\arguments{
\item{Lbd}{A (K x K x D) array with Poisson stepwise intensities, where K is the number of clusters and D is the number of time segments.}

\item{Pi}{A vector of length K. It contains the proportions of nodes in each cluster.}

\item{eta}{A vector of length D containing the positive ordered change points. The last entry is equal to T.}

\item{N}{An integer. The number of nodes in the graph.}
}
\value{
\item{events}{ A (3 x Nb.events) matrix. The first row contains the ordered interaction times, the second row the source nodes, the third row the destination nodes. Currently, only undirected interactions are taken into account. Thus, for each interaction time, the source node is stricly smaller than the destination node. No self loops allowed.}

\item{z}{An integer vector of length N. It contains the cluster labels of nodes.}
}
\description{
Function to simulate a dataset.
}
\examples{
  
	N <- 100                         # nodes
	K <- 3                           # clusters
	D <- 4                           # time segments
	Th <- 10                         # final time T
	up <- 6                          # two parameters to manange contranst in Lambda
	sc <- 0.02                                        
	eta <- sort(runif(D-1, 0, Th))   # change points
	eta <- c(eta, Th)                                  
	Lbd <- array(dim = c(K,K,D))     # Poisson intensities
	Lbd[,,1] <- sc*1
	diag(Lbd[,,1]) <- sc*up
	Lbd[,,2] <- sc*1
	Lbd[1,1,2] <- Lbd[1,2,2] <- Lbd[2,1,2] <- Lbd[3,3,2] <- sc*up
	Lbd[,,3] <- sc*up
	diag(Lbd[,,3]) <- sc*1
	Lbd[,,4] <- sc*up
	Lbd[1,1,4] <- Lbd[1,2,4] <- Lbd[2,1,4] <- Lbd[3,3,4] <- sc*1 
	Pi <- rep(1, times = K)                           # proportion to clusters

	## -- Simu
	out <- ModSim(Lbd, Pi, eta, N)
	events <- out$events
	z <- out$z
  
}