% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeqic.R
\name{computeqic}
\alias{computeqic}
\title{Quasi Information Criterion}
\usage{
computeqic(object)
}
\arguments{
\item{object}{a fitted GEE model from the gee package.}
}
\value{
A vector or matrix with the QIC, QICu, quasi likelihood,
    CIC, the number of mean effect parameters, and the corrected
    QIC for each GEE object
}
\description{
Function for calculating the quasi-likelihood under the independence model
information criterion (QIC), quasi-likelihood, correlation information
criterion (CIC), and corrected QIC for one or several fitted geeglm model
object from the geepack package.
}
\details{
QIC is used to select a correlation structure. The QICu is used to compare
models that have the same working correlation matrix and the same
quasi-likelihood form but different mean specifications. CIC has been
suggested as a more robust alternative to QIC when the model for the mean
may not fit the data very well and when models with different correlation
structures are compared.

Models with smaller values of QIC, CIC, QICu, or QICC are preferred.
}
\examples{

library(gee)
data(Arterial)
fit <- gee(Pressure ~ Time + Treatment, id=Subject,
       data=Arterial, family=gaussian, corstr="AR-M")
computeqic(fit)

}
\references{
Pan, W. (2001). Akaike's information criterion in
    generalized estimating equations. Biometrics, 57, 120-125.
    Hardin, J.W.  and Hilbe, J.M. (2012). Generalized
    Estimating Equations, 2nd Edition, Chapman and Hall/CRC: New
    York.

    Hin, L.-Y. and Wang, Y-G.
    (2009). Working-correlation-structure identification in
    generalized estimating equations, Statistics in Medicine 28:
    generalized estimating equations, Statistics in Medicine 28:
    642-658.  Thall, P.F.  and Vail, S.C. (1990).
    Covariance Models for Longitudinal Count Data with
    Overdispersion.  Biometrics, 46, 657-671.
}
\author{
Alirio Cruz \email{nelson-alirio.cruz@uib.es},
        Claus Ekstrom \email{claus@rprimer.dk},
        Brian McLoone \email{bmcloone@pdx.edu} and
         Steven Orzack \email{orzack@freshpond.org}
}
