% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_records.R
\name{map_records_insilicova}
\alias{map_records_insilicova}
\title{Map VA records to InsilicoVA.}
\usage{
map_records_insilicova(records, csv_outfile = "")
}
\arguments{
\item{records}{A dataframe, obtained from reading an ODKBriefcase
export of records collected with the WHO questionnaire.}

\item{csv_outfile}{Path to a file to write transformed data to.
Defaults to empty string, in which case no file is written.}
}
\value{
A dataframe, with the VA records mapped to the variables required
  by InsilicoVA.
}
\description{
\code{map_records} transform data collected with the WHO VA instrument
  for coding with the InsilicoVA algorithm.
}
\examples{
\dontrun{
records <- read.csv('who_va_output.csv')
output_data <- map_records_tariff2(records)
}

}
\references{
Tyler H. McCormick, Zehang R. Li, Clara Calvert, Amelia C. Crampin, Kathleen Kahn and Samuel J. Clark (2014). Probabilistic cause-of-death assignment using verbal autopsies, Journal of the American Statistical Association, to appear
}

