/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.archive;

import java.util.List;
import java.util.Vector;
import org.mutoss.gui.Design;
import org.mutoss.gui.archive.DesignArchive;
import org.mutoss.gui.archive.SaveException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignArchiveControl {
    DesignArchive searchResults;
    DesignArchive defaultEntered;
    public static final String SEARCH = "search";
    public static final String ENTERED = "entered";
    List<DesignArchive> archiveLibrary = new Vector<DesignArchive>();
    String searchResultsFile = System.getProperty("user.home") + "/" + "searchResults.RData";
    String defaultEnteredFile = System.getProperty("user.home") + "/" + "enteredDesigns.RData";

    public DesignArchiveControl() {
        this.searchResults = new DesignArchive(this.searchResultsFile);
        this.defaultEntered = new DesignArchive(this.defaultEnteredFile);
    }

    public void save() {
        try {
            this.searchResults.save();
            this.defaultEntered.save();
            for (DesignArchive da : this.archiveLibrary) {
                da.save();
            }
        }
        catch (SaveException e) {
            e.printStackTrace();
        }
    }

    public void addSearchResult(Design design) {
        this.searchResults.addDesign(design);
    }

    public void addEnteredDesign(Design design) {
        this.defaultEntered.addDesign(design);
    }

    public List<Design> getDesigns(int t, int p, int s1, int s2, String string) {
        DesignArchive da = null;
        Vector<Design> result = new Vector<Design>();
        if (string.equals(SEARCH)) {
            da = this.searchResults;
        } else if (string.equals(ENTERED)) {
            da = this.defaultEntered;
        }
        for (Design d : da.designs) {
            if (d.t != t || d.p != p || d.s < s1 || d.s > s2) continue;
            result.add(d);
        }
        return result;
    }
}

