package org.mutoss.gui;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.jdesktop.swingworker.SwingWorker;
import org.mutoss.config.ClassConfig;
import org.mutoss.config.Configuration;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class DesignSelectionPanel extends JPanel implements ListSelectionListener, ActionListener, MouseListener {
	
	DesignTable designTable;
	//JList designList;
	//DefaultListModel lmDesign;
	//JTextArea jta;
	HTMLOutputPane jta;
	List<Design> designs;
	JCheckBox jcbPackageArchive = new JCheckBox("Designs from package archive");
	JCheckBox jcbCrossdes = new JCheckBox("Designs generated by package crossdes");
	JCheckBox jcbMyDesigns = new JCheckBox("Designs manually entered");
	JCheckBox jcbSearch = new JCheckBox("Designs from previous search runs");
	CrossoverGUI gui;
	JSplitPane pane;	
	
	public DesignSelectionPanel(CrossoverGUI gui) {
		this.gui = gui;
		
		pane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, new JScrollPane(getLeftSide()), getRightSide());
		
		setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx=1; c.weighty=1;
		add(pane, c);
        
        loadDefaults();
	}
	
	public JPanel getLeftSide() {
		JPanel panel = new JPanel();
		
		String cols = "5dlu, fill:min:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:min:grow, 5dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 5dlu";
        
        FormLayout layout = new FormLayout(cols, rows);

        panel.setLayout(layout);
        CellConstraints cc = new CellConstraints();
		
		int row = 2;
    	
    	panel.add(new JLabel("List of designs:"), cc.xy(2, row));
        		
        row+=2;
        
        designTable = new DesignTable(gui);	
        designTable.addMouseListener(this);
		designTable.getSelectionModel().addListSelectionListener(this);
		
		panel.add(new JScrollPane(designTable), cc.xy(2, row));        
    	
        row+=2;
        
        panel.add(jcbPackageArchive, cc.xy(2, row));
        jcbPackageArchive.setSelected(true);
        jcbPackageArchive.addActionListener(this);
        
        row+=2;
        
        panel.add(jcbCrossdes, cc.xy(2, row));
        jcbCrossdes.setSelected(true);
        jcbCrossdes.addActionListener(this);
        
        row+=2;
        
        panel.add(jcbMyDesigns, cc.xy(2, row));
        jcbMyDesigns.setSelected(true);
        jcbMyDesigns.addActionListener(this);
        
        row+=2;
        
        panel.add(jcbSearch, cc.xy(2, row));
        jcbSearch.setSelected(true);
        jcbSearch.addActionListener(this);
        
        return panel;
	}
	
	public JPanel getRightSide() {
		JPanel panel = new JPanel();
		
		String cols = "5dlu, fill:min:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:min:grow, 5dlu";
        
        FormLayout layout = new FormLayout(cols, rows);

        panel.setLayout(layout);
        CellConstraints cc = new CellConstraints();
		
		int row = 2;
		panel.add(new JLabel("Selected design:"), cc.xy(2, row));
		
		row+=2;
		
		jta = new HTMLOutputPane(gui);
		jta.setFont(new Font("Monospaced", Font.PLAIN, 12));
		/*jta.setLineWrap(false);		
		jta.setMargin(new Insets(4,4,4,4));*/
		
		panel.add(new JScrollPane(jta), cc.xy(2, row));		
		
		return panel;
	}
	
	ClassConfig ac = new ClassConfig(Configuration.getInstance(), DesignSelectionPanel.class);
	
	public void loadDefaults() {
		jcbPackageArchive.setSelected(ac.getBoolProperty("PackageArchive", true));
		jcbCrossdes.setSelected(ac.getBoolProperty("Crossdes", true));
		jcbMyDesigns.setSelected(ac.getBoolProperty("MyDesigns", true));
		jcbSearch.setSelected(ac.getBoolProperty("Search", true));
	}
    
	public void saveDefaults() {
		ac.setBoolProperty("PackageArchive", jcbPackageArchive.isSelected());
		ac.setBoolProperty("Crossdes", jcbCrossdes.isSelected());
		ac.setBoolProperty("MyDesigns", jcbMyDesigns.isSelected());
		ac.setBoolProperty("Search", jcbSearch.isSelected());
	}
	
	
	public DesignSelectionPanel(List<Design> designs, CrossoverGUI gui) {
		this(gui);
		setDesigns(designs);
	}

	public void setDesigns(List<Design> designs) {
		designTable.setDesigns(designs);
	}

	public void valueChanged(ListSelectionEvent e) {
		int i = designTable.getSelectedRow();
		if (i == -1) return;
		Design design = designTable.getModel().getDesigns().get(designTable.convertRowIndexToModel(i));		
		jta.showDesign(design);
	}

	public void actionPerformed(ActionEvent e) {		
		SwingWorker<Void, Void> worker = new FillTableWorker(gui);
		worker.execute();		
		saveDefaults();
	}

	public void mouseClicked(MouseEvent e) {}

	public void mousePressed(MouseEvent e)  {popup(e);}
	public void mouseReleased(MouseEvent e) {popup(e);}

	public void popup(MouseEvent e) {
	    if (e.isPopupTrigger()) {
	    	int r = designTable.rowAtPoint(e.getPoint());
	        JPopupMenu popup = makePopupMenu(r);
            popup.show(e.getComponent(), e.getX(), e.getY());
	    }
	}

	private JPopupMenu makePopupMenu(int r) {
		//TODO should be an own class.
		JPopupMenu jpm = new JPopupMenu();
		jpm.add(new JMenuItem("Delete"));        
		return jpm;
	}

	public void mouseEntered(MouseEvent e) {}

	public void mouseExited(MouseEvent e) {}
	
}
