#'@title HIPC_Stanford data
#'
#'@description HIPC T cell data set from HIPC program for patients 1228 and 1369 (replicate 1A from Stanford).
#'
#'@docType data
#
#'@keywords data
#'
#'@name HIPC_Stanford
#'
#'@aliases HIPC_Stanford_1228_1A HIPC_Stanford_1228_1A_labels
#'HIPC_Stanford_1369_1A HIPC_Stanford_1369_1A_labels
#'
#'@usage data(HIPC_Stanford)
#'
#'@details This immunophenotyping T cell panel from the Lyoplate HIPC dataset
#'was used as part of the FlowCAP III Lyoplate challenge.
#'
#'@details Flow cytometry data set from the HIPC T-cell panel study. In the
#'HIPC T-cell panel study, Flow cytometry was measured in 3 samples for each
#'3 patients (IDs: 1228, 1349 and 1369) with 3 replicates each (1A, 2B and 3C)
#'in 7 centers (NHLBI, Yale, UCLA, CIMR, Baylor, Stanford and Miami), i.e. 63
#'data sets in total. Manual gating was performed in the different centers to
#'cluster te observed cells into one of 10 cellular populations:
#'\enumerate{
#' \item{CD8 Effector}
#' \item{CD8 Naive}
#' \item{CD8 Central Memory}
#' \item{CD8 Effector Memory}
#' \item{CD8 Activated}
#' \item{CD4 Effector}
#' \item{CD4 Naive}
#' \item{CD4 Central Memory}
#' \item{CD4 Effector Memory}
#' \item{CD4 Activated}
#'}
#

#'@format The data are composed of 4 objects:
#'\describe{
#'  \item{\code{HIPC_Stanford_1228_1A}: }{a \code{data.frame} of 31342 cells and 7 markers.}
#'  \item{\code{HIPC_Stanford_1228_1A_labels}: }{a \code{factor} vector with the cell type
#'  of each of the 31342 observed cells.}
#'  \item{\code{HIPC_Stanford_1369_1A}: }{a \code{data.frame} of 33992 cells and 7 markers.}
#'  \item{\code{HIPC_Stanford_1369_1A_labels}: }{a \code{factor} vector with the cell type
#'  of each of the 33992 observed cells.}
#'}
#'
#'
#'@references Maecker HT, McCoy JP & Nussenblatt R (2012). Standardizing
#'immunophenotyping for the human immunology project. Nature Reviews Immunology,
#'12(3):191--200. DOI: 10.1038/nri3158
#'
#'Finak G, Langweiler M, Jaimes M, Malek M, Taghiyar J, Korin Y, Raddassi K,
#'Devine L, Obermoser G, Pekalski ML, Pontikos N, Diaz A, Heck S, Villanova F,
#'Terrazzini N, Kern F, Qian Y, Stanton R, Wang K, Brandes A, Ramey J,
#'Aghaeepour N, Mosmann T, Scheuermann RH, Reed E, Palucka K, Pascual V,
#'Blomberg BB, Nestle F, Nussenblatt RB, Brinkman RR, Gottardo R, Maecker H &
#'McCoy JP (2016). Standardizing Flow Cytometry Immunophenotyping Analysis from the Human
#'ImmunoPhenotyping Consortium. Scientific Reports. 10(6):20686. DOI: 10.1038/srep20686.
#'
#'
#'@source \url{https://www.hipc-dashboard.org/}
#'\url{https://immunespace.org/}
#'\url{https://datatools.immunespace.org/project/HIPC/Lyoplate/begin.view?pageId=study.DATA_ANALYSIS}
"HIPC_Stanford_1228_1A"
"HIPC_Stanford_1228_1A_labels"
"HIPC_Stanford_1369_1A"
"HIPC_Stanford_1369_1A_labels"
