% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.heuristics.MCCHeuristic.R
\name{MCCHeuristic}
\alias{MCCHeuristic}
\title{Feature-clustering based on Matthews Correlation Coefficient score.}
\description{
Performs the feature-clustering using MCC score.
Valid for both bi-class and multi-class problems
}
\seealso{
\code{\link{Dataset}}, \code{\link[mccr]{mccr}}
}
\keyword{cluster}
\keyword{manip}
\section{Super class}{
\code{\link[D2MCS:GenericHeuristic]{D2MCS::GenericHeuristic}} -> \code{MCCHeuristic}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MCCHeuristic$new()}}
\item \href{#method-heuristic}{\code{MCCHeuristic$heuristic()}}
\item \href{#method-clone}{\code{MCCHeuristic$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Empty function used to initialize the object arguments in
runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCCHeuristic$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-heuristic"></a>}}
\if{latex}{\out{\hypertarget{method-heuristic}{}}}
\subsection{Method \code{heuristic()}}{
Calculates the Matthews correlation Coefficient (MCC) score.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCCHeuristic$heuristic(col1, col2, column.names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col1}}{A \link{numeric} vector or matrix required to perform the
clustering operation.}

\item{\code{col2}}{A \link{numeric} vector or matrix to perform the clustering
operation.}

\item{\code{column.names}}{An optional \link{character} vector with the names of
both columns.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} vector of length 1 or \link{NA} if an error
occurs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCCHeuristic$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
