% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.Subset.R
\name{Subset}
\alias{Subset}
\title{Classification set.}
\description{
The \code{\link{Subset}} is used for testing or classification
purposes. If a target class is defined the \code{\link{Subset}} can be used
as test and classification, otherwise the \code{\link{Subset}} only
classification is compatible.
}
\details{
Use \code{\link{Dataset}} to ensure the creation of a valid
\code{\link{Subset}} object.
}
\seealso{
\code{\link{Dataset}}, \code{\link{DatasetLoader}},
\code{\link{Trainset}}
}
\keyword{attribute}
\keyword{datagen}
\keyword{datasets}
\keyword{manip}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Subset$new()}}
\item \href{#method-getColumnNames}{\code{Subset$getColumnNames()}}
\item \href{#method-getFeatures}{\code{Subset$getFeatures()}}
\item \href{#method-getID}{\code{Subset$getID()}}
\item \href{#method-getIterator}{\code{Subset$getIterator()}}
\item \href{#method-getClassValues}{\code{Subset$getClassValues()}}
\item \href{#method-getClassBalance}{\code{Subset$getClassBalance()}}
\item \href{#method-getClassIndex}{\code{Subset$getClassIndex()}}
\item \href{#method-getClassName}{\code{Subset$getClassName()}}
\item \href{#method-getNcol}{\code{Subset$getNcol()}}
\item \href{#method-getNrow}{\code{Subset$getNrow()}}
\item \href{#method-getPositiveClass}{\code{Subset$getPositiveClass()}}
\item \href{#method-isBlinded}{\code{Subset$isBlinded()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$new(
  dataset,
  class.index = NULL,
  class.values = NULL,
  positive.class = NULL,
  feature.id = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{A fully filled \link{data.frame}.}

\item{\code{class.index}}{A \link{numeric} value identifying the column
representing the target class}

\item{\code{class.values}}{A \link{character} vector containing all the values
of the target class.}

\item{\code{positive.class}}{A \link{character} value representing the positive
class value.}

\item{\code{feature.id}}{A \link{numeric} value specifying the column number
used as identifier.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getColumnNames"></a>}}
\if{latex}{\out{\hypertarget{method-getColumnNames}{}}}
\subsection{Method \code{getColumnNames()}}{
Get the name of the columns comprising the subset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getColumnNames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector containing the name of each column.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFeatures"></a>}}
\if{latex}{\out{\hypertarget{method-getFeatures}{}}}
\subsection{Method \code{getFeatures()}}{
Gets the values of all features or those indicated by
arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getFeatures(feature.names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature.names}}{A \link{character} vector comprising the name of the
features to be obtained.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{character} vector or NULL if subset is empty.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getID"></a>}}
\if{latex}{\out{\hypertarget{method-getID}{}}}
\subsection{Method \code{getID()}}{
Gets the column name used as identifier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getID()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of size 1 of NULL if column id is not
defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getIterator"></a>}}
\if{latex}{\out{\hypertarget{method-getIterator}{}}}
\subsection{Method \code{getIterator()}}{
Creates the \link{DIterator} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getIterator(chunk.size = private$chunk.size, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chunk.size}}{An \link{integer} value indicating the size of chunks taken
over each iteration. By default chunk.size is defined as 10000.}

\item{\code{verbose}}{A \link{logical} value to specify if more verbosity is
needed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{DIterator}} object to transverse through
\code{\link{Subset}} instances.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getClassValues"></a>}}
\if{latex}{\out{\hypertarget{method-getClassValues}{}}}
\subsection{Method \code{getClassValues()}}{
Gets all the values of the target class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getClassValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{factor} vector with all the values of the target class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getClassBalance"></a>}}
\if{latex}{\out{\hypertarget{method-getClassBalance}{}}}
\subsection{Method \code{getClassBalance()}}{
The function is used to compute the ratio of each class
value in the \code{\link{Subset}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getClassBalance(target.value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target.value}}{The class value used as reference to perform the
comparison.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getClassIndex"></a>}}
\if{latex}{\out{\hypertarget{method-getClassIndex}{}}}
\subsection{Method \code{getClassIndex()}}{
The function is used to obtain the index of the column
containing the target class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getClassIndex()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getClassName"></a>}}
\if{latex}{\out{\hypertarget{method-getClassName}{}}}
\subsection{Method \code{getClassName()}}{
The function is used to specify the name of the column
containing the target class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getClassName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNcol"></a>}}
\if{latex}{\out{\hypertarget{method-getNcol}{}}}
\subsection{Method \code{getNcol()}}{
The function is in charge of obtaining the number of columns
comprising the \code{\link{Subset}}. See \code{\link{ncol}} for more
information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getNcol()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \link{integer} of length 1 or \link{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNrow"></a>}}
\if{latex}{\out{\hypertarget{method-getNrow}{}}}
\subsection{Method \code{getNrow()}}{
The function is used to determine the number of rows present
in the \code{\link{Subset}}. See \code{\link{nrow}} for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getNrow()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \link{integer} of length 1 or \link{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPositiveClass"></a>}}
\if{latex}{\out{\hypertarget{method-getPositiveClass}{}}}
\subsection{Method \code{getPositiveClass()}}{
The function returns the value of the positive class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$getPositiveClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of size 1 or \link{NULL} if not defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isBlinded"></a>}}
\if{latex}{\out{\hypertarget{method-isBlinded}{}}}
\subsection{Method \code{isBlinded()}}{
The function is used to check if the \link{Subset} contains
a target class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subset$isBlinded()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{logical} value where \link{TRUE} represents the absence
of target class and \link{FALSE} its presence.
}
}
}
