% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_multi_missing_species.R
\name{add_multi_missing_species}
\alias{add_multi_missing_species}
\title{Calculates the number of missing species to be assigned to each island clade
in the island_tbl object and assigns the missing species to them. In the case
that multiple genera are in an island clade and each have missing species
the number of missing species is summed. Currently the missing species
are assigned to the genus that first matches with the missing species table,
however a more biologically or stochastic assignment is in development.}
\usage{
add_multi_missing_species(missing_species, missing_genus, island_tbl)
}
\arguments{
\item{missing_species}{Numeric number of missing species from the phylogeny
that belong to the colonising clade.}

\item{missing_genus}{A list of character vectors containing the genera in
each island clade}

\item{island_tbl}{An instance of the `Island_tbl` class.}
}
\value{
Object of Island_tbl class
}
\description{
Calculates the number of missing species to be assigned to each island clade
in the island_tbl object and assigns the missing species to them. In the case
that multiple genera are in an island clade and each have missing species
the number of missing species is summed. Currently the missing species
are assigned to the genus that first matches with the missing species table,
however a more biologically or stochastic assignment is in development.
}
\examples{
phylod <- create_test_phylod(test_scenario = 6)
island_tbl <- suppressWarnings(extract_island_species(
  phylod = phylod,
  extraction_method = "asr",
))
phylod <- create_test_phylod(test_scenario = 7)
island_tbl <- suppressWarnings(extract_island_species(
  phylod = phylod,
  extraction_method = "asr",
  island_tbl = island_tbl
))

missing_species <- data.frame(
  clade_name = "bird",
  missing_species = 1,
  endemicity_status = "endemic"
)

missing_genus <- list("bird", character(0))

island_tbl <- add_multi_missing_species(
  missing_species = missing_species,
  missing_genus = missing_genus,
  island_tbl = island_tbl
)
}
