% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endemicity_to_sse_states.R
\name{sse_states_to_endemicity}
\alias{sse_states_to_endemicity}
\title{Convert SSE states back to endemicity status}
\usage{
sse_states_to_endemicity(states, sse_model = "musse")
}
\arguments{
\item{states}{integer vector of tip states, as expected by SSE models}

\item{sse_model}{either "musse" (default) or "geosse". MuSSE expects state
values 1, 2, 3, which here we encode as "not_present", "endemic",
"nonendemic", respectively. GeoSSE expects trait values 0, 1, 2, with 0 the
widespread state (here, "nonendemic"), and 1 and 2 are "not_present" and
"endemic", respectively.}
}
\value{
character vector with values "endemic", "nonendemic" and/or
"not_present"
}
\description{
Convert SSE states back to endemicity status
}
