% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_info.R
\name{model_info}
\alias{model_info}
\alias{model_info.lm}
\alias{model_info.randomForest}
\alias{model_info.svm}
\alias{model_info.glm}
\alias{model_info.glmnet}
\alias{model_info.cv.glmnet}
\alias{model_info.ranger}
\alias{model_info.gbm}
\alias{model_info.model_fit}
\alias{model_info.train}
\alias{model_info.rpart}
\alias{model_info.default}
\title{Exract info from model}
\usage{
model_info(model, ...)

\method{model_info}{lm}(model, ...)

\method{model_info}{randomForest}(model, ...)

\method{model_info}{svm}(model, ...)

\method{model_info}{glm}(model, ...)

\method{model_info}{glmnet}(model, ...)

\method{model_info}{cv.glmnet}(model, ...)

\method{model_info}{ranger}(model, ...)

\method{model_info}{gbm}(model, ...)

\method{model_info}{model_fit}(model, ...)

\method{model_info}{train}(model, ...)

\method{model_info}{rpart}(model, ...)

\method{model_info}{default}(model, ...)
}
\arguments{
\item{model}{- model object}

\item{...}{- another arguments

Currently supported packages are:
\itemize{
\item class `cv.glmnet` and `glmnet` - models created with `glmnet` package
\item class `glm` - generalized linear models
\item class `model_fit` - models created with `parsnip` package
\item class `lm` - linear models created with `stats::lm`
\item class `ranger` - models created with `ranger` package
\item class `randomForest` - random forest models created with `randomForest` package
\item class `svm` - support vector machines models created with the `e1071` package
\item class `train` - models created with `caret` package
\item class `gbm` - models created with `gbm` package
}}
}
\value{
A named list of class \code{model_info}
}
\description{
This generic function let user extract base information about model. The function returns a named list of class \code{model_info} that
contain about package of model, version and task type. For wrappers like \code{mlr} or \code{caret} both, package and wrapper inforamtion
are stored
}
\examples{
aps_lm_model4 <- lm(m2.price ~., data = apartments)
model_info(aps_lm_model4)

library("ranger")
model_regr_rf <- ranger::ranger(m2.price~., data = apartments, num.trees = 50)
model_info(model_regr_rf)

}
