% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_mljar.R
\name{explain_mljar}
\alias{explain_mljar}
\title{Create explainer from your mljar model}
\usage{
explain_mljar(
  model,
  project_title,
  data = NULL,
  y = NULL,
  weights = NULL,
  predict_function = NULL,
  residual_function = NULL,
  ...,
  label = NULL,
  verbose = TRUE,
  precalculate = TRUE,
  colorize = TRUE,
  model_info = NULL
)
}
\arguments{
\item{model}{object - a mljar model to be explained}

\item{project_title}{character - a name of project_title  in which model was built. Without it predictions are unreachable.}

\item{data}{data.frame or matrix - data that was used for fitting. If not provided then will be extracted from the model. Data should be passed without target column (this shall be provided as the \code{y} argument). NOTE: If target variable is present in the \code{data}, some of the functionalities my not work properly.}

\item{y}{numeric vector with outputs / scores. If provided then it shall have the same size as \code{data}}

\item{weights}{numeric vector with sampling weights. By default it's \code{NULL}. If provided then it shall have the same length as \code{data}}

\item{predict_function}{function that takes two arguments: model and new data and returns numeric vector with predictions}

\item{residual_function}{function that takes three arguments: model, data and response vector y. It should return a numeric vector with model residuals for given data. If not provided, response residuals (\eqn{y-\hat{y}}) are calculated.}

\item{...}{other parameters}

\item{label}{character - the name of the model. By default it's extracted from the 'class' attribute of the model}

\item{verbose}{if TRUE (default) then diagnostic messages will be printed.}

\item{precalculate}{if TRUE (default) then 'predicted_values' and 'residuals' are calculated when explainer is created. This will happenn also if 'verbose' is TRUE}

\item{colorize}{if TRUE (default) then \code{WARNINGS}, \code{ERRORS} and \code{NOTES} are colorized. Will work only in the R console.}

\item{model_info}{a named list (\code{package}, \code{version}, \code{type}) containg information about model. If \code{NULL}, \code{DALEX} will seek for information on it's own.}
}
\value{
explainer object (\code{\link[DALEX]{explain}}) ready to work with DALEX
}
\description{
DALEX is designed to work with various black-box models like tree ensembles, linear models, neural networks etc.
Unfortunately packages that create such models are very inconsistent between many platforms and programming languages. Different tools use different interfaces to train, validate and use models.
One of those tools, we would like to make more accessible is mljar.
}
\examples{
\dontrun{
library("DALEXtra")
library(mljar)
titanic_test <- read.csv(system.file("extdata", "titanic_test.csv", package = "DALEXtra"))

model <- mljar_fit(titanic_test[,1:17], titanic_test[,18],
                   proj_title="Project title", exp_title="experiment title",
                   algorithms = c("logreg"), metric = "logloss")
# It Works
explainer <- explain_mljar(model, project_title = "Project title",
                           data = titanic_test[,1:17], y = titanic_test[,18])
# But it works aswell
explainer <- explain_mljar(model, project_title = "Project title",
                           verbose = FALSE, precalculate = FALSE)
}
}
