\name{cat2Table}
\alias{cat2Table}
\title{Fitted Values and CIs for 2-Categorical Interactions}
\description{This function makes a table of fitted values and confidence intervals for all of the combinations of two categorical variables in an interaction. }
\usage{
cat2Table(eff.obj, digits, rownames=NULL, colnames=NULL)
}
\arguments{
  \item{eff.obj}{An object generated by \code{effect} from the \code{effects} package where the effect is calculated for two factors involved in an interaction.}
  \item{digits}{Number of digits of the fitted values and confidence intervals to print.}
  \item{rownames}{An optional vector of row names for the table, if \code{NULL}, the levels of the factor will be used}
  \item{colnames}{An optional vector of column names for the table, if \code{NULL}, the levels of the factor will be used}
}
\value{
A matrix of fitted values and confidence intervals
}
\author{Dave Armstrong}
\examples{
library(car)
data(Duncan)
Duncan$inc.cat <- cut(Duncan$income, 3)
mod <- lm(prestige ~ inc.cat*type + income, data=Duncan)
e1 <- effect("inc.cat*type", mod)
cat2Table(e1)
}