% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{binVar}
\alias{binVar}
\title{Bin a Variable}
\usage{
binVar(
  x,
  bins = 4,
  method = c("intervals", "proportions"),
  labels = FALSE,
  include.lowest = TRUE,
  right = FALSE,
  ...
)
}
\arguments{
\item{x}{Continuous variable to be binnged}

\item{bins}{Number of groups in new variable}

\item{method}{Method for generating "intervals" for fixed-width intervals and "proportions" for cut-points based on quantiles of the distribution.}

\item{labels}{An optional vector of labels to apply to the groups}

\item{include.lowest}{Logical indicating whether a value equal to the lowest (if \code{right=TRUE}) or highest (if \code{right=FALSE}) should be included.}

\item{right}{Logical indicating Whether the intervals should be closed on the right and open on the left (if \code{TRUE}) or vice versa (if \code{FALSE}).  Open intervals are those that do not include the end-point of the range and closed intervals do.}

\item{...}{Other arguments to be passed down to \code{cut}


Function adapted from \code{binVariable} from the \pkg{RcmdrMisc} pacakge.}
}
\value{
A factor
}
\description{
Bins a continuous variable into a categorical variable
}
\author{
John Fox
}
