% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{pwCorrMat}
\alias{pwCorrMat}
\alias{sig.cor}
\title{Pairwise Correlation Matrix}
\usage{
pwCorrMat(
  formula,
  data,
  method = c("z", "t", "sim"),
  weight = NULL,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{formula}{A right-sided formula giving the variables to be correlated separated by pluses.}

\item{data}{A data frame where the variables in the formula can be found.}

\item{method}{A method for calculating the significance of the of the 
correlation - one of "z", "t" or "sim".  When correlations are 
calculated with weights, a bootstrap is used to generate p-values 
regardless of the method specified.  See details for more.}

\item{weight}{A vector of weightings as long as there are rows in \code{data}.}

\item{alpha}{Cutoff for identifying significant correlations.}

\item{...}{Other arguments to be passed down to \code{sig.cor}.}
}
\value{
An object of class \code{pwc}, which is a list with elements \code{rSig} 
which is a lower-triangular correlation matrix where only significant correlations 
are printed, \code{r} which is the raw-data pairwise correlation matrix and 
\code{p} which gives the p-values of all of the correlations.
}
\description{
Prints pairwise correlation matrix flagging statistically significant
correlations using one of a few different methods.
}
\details{
The significance is found through one of three ways.  For correlation \code{r}, 
the z-transformation is .5*log((1+r)/(1-r)), the p-value for which is found using 
the standard normal distribution. The t-transformation is r*sqrt((n-2)/(1-r^2)), 
the p-value for which is found using a t-distribution with n-2 degrees of freedom. 
The "sim" method uses a permutation test to build the sampling distribution of the 
correlation under the null hypothesis and then calculates a p-value from that 
distribution.
}
