% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_DAP_seq.R
\name{solve_DAP_seq}
\alias{solve_DAP_seq}
\title{Solves DAP optimization problem for a given sequence of lambda values}
\usage{
solve_DAP_seq(X1, X2, lambda_seq, eps = 1e-04, maxiter = 10000,
  feature_max = nrow(X1) + nrow(X2))
}
\arguments{
\item{X1}{A n1 x p matrix of group 1 data (scaled).}

\item{X2}{A n2 x p matrix of group 2 data (scaled).}

\item{lambda_seq}{A supplied sequence of tunning parameters.}

\item{eps}{Convergence threshold for the block-coordinate decent algorithm based on the maximum element-wise change in \eqn{V}. The default is 1e-4.}

\item{maxiter}{Maximum number of iterations, the default is 10000.}

\item{feature_max}{An upper bound on the number of nonzero features in the solution; the default value is the total sample size. The algorithm trims the supplied \code{lambda_seq} to eliminate solutions that exceed \code{feature_max}.}
}
\value{
A list of
   \item{lambda_seq}{A sequence of considered lambda values.}
       \item{V1_mat}{A p x m matrix with columns corresponding to the 1st projection vector V1 found at each lambda from \code{lambda_seq}.}
       \item{V2_mat}{A p x m matrix with columns corresponding to the 2nd projection vector V2 found at each lambda from \code{lambda_seq}.}
      
       \item{nfeature_vec}{A sequence of corresponding number of selected features for each value in \code{lambda_seq}.}
}
\description{
Uses block-coordinate descent algorithm with warm initializations, starts with the maximal supplied lambda value.
}
\examples{
## This is an example for solve_DAP_seq

## Generate data
n_train = 50
n_test = 50
p = 100
mu1 = rep(0, p)
mu2 = rep(3, p)
Sigma1 = diag(p)
Sigma2 = 0.5* diag(p)

## Build training data
x1 = MASS::mvrnorm(n = n_train, mu = mu1, Sigma = Sigma1)
x2 = MASS::mvrnorm(n = n_train, mu = mu2, Sigma = Sigma2)
xtrain = rbind(x1, x2)
ytrain = c(rep(1, n_train), rep(2, n_train))

## Standardize the data
out_s = standardizeData(xtrain, ytrain, center = FALSE)

####use solve_proj_seq
fit = solve_DAP_seq(X1 = out_s$X1, X2 = out_s$X2, lambda_seq = c(0.2, 0.3, 0.5, 0.7, 0.9))
}
