% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chaotic.ts.R
\name{logistic.ts}
\alias{logistic.ts}
\title{Simulation of time series from the Logistic equation}
\usage{
logistic.ts(u.min = 1, u.max = 4, sample = 1000, transient = 100,
  B = 100, doplot = TRUE)
}
\arguments{
\item{u.min}{a non-negative integer denoting a lower bound for the parameter \code{u} (Default 1).}

\item{u.max}{a non-negative integer denoting an upper bound for the parameter \code{u} (Default 4).}

\item{sample}{a non-negative integer denoting the length of each time serie (Default 1000).}

\item{transient}{a non-negative integer denoting the number of observations that will be discarded to ensure that the values of each time serie are in the attractor (Default 100).}

\item{B}{a non-negative integer denoting the number of series that will be generated for several \code{u}-parameter values. The number of simulated series must be at least 100 (Default 100).}

\item{doplot}{a logical value denoting if you want to draw a plot \code{TRUE} or not \code{FALSE}. If it is \code{TRUE} shows four graphs: the evolution of the temporal trajectories for an initial period, the evolution of these for the whole period, the attractor and its projections on the Cartesian plane and the bifurcation diagram (Default \code{TRUE}).}
}
\value{
A list containing as many items as series we want to simulate \code{B}. Each of them has the following attributes: the value of the parameter \code{u}, the value of the initial condition \code{xo} and a time serie from the iterated Logistic equation.
}
\description{
This function simulates time series from the Logistic equation considering the argument set selected by the user. The initial condition of each time serie is a random number between 0 and 1.
}
\examples{
## Simulates 100 time series from the logistic equation for
## u-parameter values in which this system exhibits a chaotic
## behaviour:
ts<-logistic.ts(u.min=3.57,u.max=4,B=100,doplot=TRUE)
}
\references{
May, R.M. 1976 Simple mathematical models with very complicated dynamics. Nature (261):459-467.
}
\seealso{
\code{\link{henon.ts}}, \code{\link{rossler.ts}}, \code{\link{lorenz.ts}}
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
