% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobian.net.R
\name{jacobian.net}
\alias{jacobian.net}
\title{Computes the partial derivatives from the best-fitted neural net model}
\usage{
jacobian.net(
  model,
  data,
  m = 1:4,
  lag = 1:1,
  timelapse = c("FIXED", "VARIABLE"),
  h = 2:10,
  w0maxit = 100,
  wtsmaxit = 1e+06,
  pre.white = TRUE,
  trace = 1,
  seed.t = TRUE,
  seed = 56666459,
  ...
)
}
\arguments{
\item{model}{a neural network model fitted using the \code{netfit} function.}

\item{data}{a \code{vector}, a time-series object \code{ts} or \code{xts}, a \code{data.frame}, a \code{data.table} or a \code{matrix} depending on the method selected in \code{timelapse}.}

\item{m}{a non-negative integer denoting a lower and upper bound for the embedding dimension (Default 1:4).}

\item{lag}{a non-negative integer denoting a lower and upper bound for the the reconstruction delay (Default 1:1).}

\item{timelapse}{a character denoting if the time-series data are sampled at uniform time-frequency e.g., 1-month, 1-day, 1-hour, 30-min, 5-min, 1-min and so on \code{FIXED} or non-uniform time-frequency which are not equally spaced in time \code{VARIABLE} (Default \code{FIXED}).}

\item{h}{a non-negative integer denoting a lower and upper bound for the number of neurones (or nodes) in the single hidden layer (Default 2:10).}

\item{w0maxit}{a non-negative integer denoting the maximum iterations to estimate the initial parameter vector of the neural net models (Default 100).}

\item{wtsmaxit}{a non-negative integer denoting the maximum iterations to estimate the weights parameter vector of the neural net models (Default 1e6).}

\item{pre.white}{a logical value denoting if the user wants to use as points to evaluate the partial derivatives the delayed vectors filtered by the neural net model chosen \code{TRUE} or not \code{FALSE} (Default \code{TRUE}).}

\item{trace}{a binary value denoting if the user wants to print the output on the console \code{1} or not \code{0} (Default 1).}

\item{seed.t}{a logical value denoting if the user wants to fix the seed \code{TRUE} or not \code{FALSE} (Default TRUE).}

\item{seed}{a non-negative integer denoting the value of the seed selected if \code{seed.t = TRUE} (Default 56666459).}

\item{...}{further arguments passed to or from \code{nnet} function.}
}
\value{
This function returns several objects considering the parameter set selected by the user. Partial derivatives are calculated analytically from the best-fitted neural net model. It also contains some useful information about the best-fitted feed-forward single hidden layer neural net model saved, the best set of weights found, the fitted values, the residuals obtained or the best embedding parameters set chosen. This function allows the R user uses the data previously obtained from the best-fitted neural network estimated by the \code{netfit} function if \code{model} is not empty. Otherwise \code{data} has to be specified.
}
\description{
This function computes analytically the partial derivatives from the best-fitted neural net model.
}
\note{
The main reason for using neural network models is not to look for the best predictive model but to estimate a model that captures the non-linear time dependence well enough and, additionally, allows us to obtain in an analytical way (instead of numerical) the jacobian functional of the unknown underlying generator system. The estimation of this jacobian or partial derivatives will later allow us to contrast our hypothesis of chaos estimating the Lyapunov exponents.
}
\examples{
## set.seed(34)
## Simulates time-series data from the Logistic map with chaos
## ts        <- DChaos::logistic.sim(n=1000, a=4)
## show(head(ts, 5))

## Computes analytically the partial derivatives from the best-fitted neural net model
## showed in the netfit example
## model    <- DChaos::netfit(ts, m=1:4, lag=1:3, timelapse="FIXED", h=2:10)
## jacobian <- DChaos::jacobian.net(model=model)
## summary(jacobian)

## Partial derivatives are calculated analytically without setting previously any neural net model
## jacobian <- DChaos::jacobian.net(data=ts, m=3:3, lag=1:1, timelapse="FIXED", h=2:10)
## summary(jacobian)
}
\references{
Eckmann, J.P., Ruelle, D. 1985 Ergodic theory of chaos and strange attractors. Rev Mod Phys 57:617–656.

Gencay, R., Dechert, W.D. 1992 An algorithm for the n lyapunov exponents of an n-dimensional unknown dynamical system. Physica D 59(1):142–157.

Shintani, M., Linton, O. 2004 Nonparametric neural network estimation of Lyapunov exponents and a direct test for chaos. Journal of Econometrics 120(1):1-33.
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
