% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeElement.R
\name{makeElement}
\alias{makeElement}
\title{Make a DDI Codebook element}
\usage{
makeElement(
  name,
  children = NULL,
  attributes = NULL,
  content = NULL,
  fill = FALSE,
  ...
)
}
\arguments{
\item{name}{Character, a DDI Codebook element name.}

\item{children}{A list of standard DDI codebook elements.}

\item{attributes}{A vector of named values.}

\item{content}{Character scalar.}

\item{fill}{Logical, fill the element with arbitrary values for its
mandatory children and attributes}

\item{...}{Other arguments, see Details.}
}
\value{
A standard list element of class \code{"DDI"} with reserved component names.
}
\description{
Creates a standard DDI element.
}
\details{
The structure of a DDI element in R follows the usual structure of
an XML node, as returned by the function \code{as_list()} from package \strong{xml2},
with one additional (first) component named ".extra" to accommodate any other
information that is not part of the DDI element.

In the DDI Codebook, most elements and their attributes are optional, but
some are mandatory. In case of attributes, some become mandatory only if the
element itself is present. The mandatory elements need to be present in the
final version of the Codebook, to pass the validation against the XML schema.

By activating the argument \code{fill}, this function creates DDI elements
containing all mandatory (sub)elements and (their) attributes, filled with
arbitrary values that can be changed later on. Some recommended elements are
also filled, as expected by the CESSDA Data Catalogue profile for DDI
Codebook.

By default, the Codebook is assumed to have a single language for all
elements. This argument \code{monolang} can be deactivated through the \code{...} gate,
in which situation the appropriate elements will receive a default argument
\code{xmlang = "en"}. For other languages, that argument can also be provided
through the \code{...} gate.

One such DDI Codebook element is the \code{stdyDscr} (Study Description), with the
associated mandatory children, for instance title, ID number, distributor,
citation, abstract etc.
}
\examples{
stdyDscr <- makeElement("stdyDscr", fill = TRUE)

# easier to extract with:
getChildren("stdyDscr/citation/titlStmt/titl", from = stdyDscr)

}
\seealso{
\code{\link{addChildren}}
\code{\link{getChildren}}
\code{\link{showDetails}}
}
\author{
Adrian Dusa
}
