% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEET_data_download.R
\name{DEET_data_download}
\alias{DEET_data_download}
\title{DEET_data_download}
\usage{
DEET_data_download(x = "enrich")
}
\arguments{
\item{x}{categorical variable containing options "ALL", "enrich",
"metadata" or "feature_matrix".}
}
\value{
Named list with the neccesary data required to input into
DEET_feature_extract or DEET_enrich. The metadata within DEET
can also be downloaded.

\itemize{
  \item feature_matrix - A gene by comparison matrix populated
   with the log2FC of gene expression for all genes, regardless
   of DE status.
  \item metadata - a comparison - by - explanatory piece of data dataframe
   providing important details to contextualize each study.
   For every pairwise comparison, the study name,
   source (SRA, TCGA, GTEx and SRA-manual),
   description from the DRA compendium,
   the number of samples (total, up-condition,
   and down-condition), samples (total ,up-condition, down-condition),
   tissue (including tumour from TCGA),
   number of DEs (total, up-condition, down-condition),
   age (mean +- sd), sex, top 15 DEGs - up, top 15 DEGs - down,
   top 5 enriched pathways, and top 5 enriched TFs.
   PMID are also available for studies selected from SRA.
   Lastly, each pairwise comparison was given an overall
   category based on those decided in Crow et al., 2019.
  \item DEET_enrich - A named list of seven objects containing
   the data frames summarizing the DEGs from comparisons within
   DEET, GMT objects of comparisons within DEET for enrichment
   through ActivePathways, GMT objects for basic pathway and TF
   enrichment, and a dataframe for the metadata of each study.
   For more detail on each element of the list, please consult
   the vignette or "?DEET_example_data", as it is a subset
   of this object
}
}
\description{
Function to automatically download the files within
the DEET database that are required for the DEET_enrich
 and DEET_feature_extractfunctions.
}
\examples{
\donttest{

# Download the metadata. Downloading other
# files within DEET are larger and take
# a bit more time.
downloaded <- DEET_data_download(x = "metadata")

# extract metadata from the list
metadata <- downloaded[["metadata"]]

}

}
\references{
Engebretsen, S., & Bohlin, J. (2019). Statistical predictions with glmnet.
Clinical epigenetics, 11(1), 1-3.
}
\author{
Dustin Sokolowski, Jedid Ahn
}
