% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BarGraphDEGRE.R
\name{BarGraphDEGRE}
\alias{BarGraphDEGRE}
\title{Create a bar plot showing the number of downregulated and upregulated genes.}
\usage{
BarGraphDEGRE(
  results,
  log2FC_cutoff = 1,
  downregulated_color = "coral2",
  upregulated_color = "cornflowerblue",
  xlab = "Regulation",
  ylab = "Number of genes",
  font.x = 10,
  font.y = 10,
  font.tickslab = 10,
  legend_position = "right",
  legend.title = "Regulation"
)
}
\arguments{
\item{results}{a data.frame object. It receives the output of the DEGRE function, filtered or not, as input.}

\item{log2FC_cutoff}{it stores the cutoff of the log2FoldChange. The default is 1.}

\item{downregulated_color}{the bar color related to the number of downregulated genes. The default is "coral2".}

\item{upregulated_color}{the bar color related to the number of upregulated genes. The default is "cornflowerblue".}

\item{xlab}{the x lab text. The default is "Regulation".}

\item{ylab}{the y lab text. The default is "Number of genes".}

\item{font.x}{the font size of the x axis. The default is 10.}

\item{font.y}{the font size of the y axis. The default is 10.}

\item{font.tickslab}{the font size of the ticks lab. The default is 10.}

\item{legend_position}{you need to specify here the position of the legend. The default is "right".}

\item{legend.title}{the title of the legend. The default is "Regulation".}
}
\value{
No return value, called for side effects
}
\description{
Create a bar plot showing the number of downregulated and upregulated genes.
}
\examples{
# Reading a CSV file for an example:
dir <- system.file("extdata", package = "DEGRE")
results_DEGRE_example <- read.csv(file.path(dir,"results_DEGRE_example.csv"))
# Running the BarGraphDEGRE function
BarGraphDEGRE(results = results_DEGRE_example,
           log2FC_cutoff = 1,
           downregulated_color = "coral2",
           upregulated_color = "cornflowerblue",
           xlab = "Regulation",
           ylab = "Number of genes",
           font.x = 10,
           font.y = 10,
           font.tickslab = 10,
           legend_position = "right",
           legend.title = "Regulation")

}
