% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{mseEr}
\alias{mseEr}
\title{Calculate Mean Squared Error( MSE) when Erlang kernel is used}
\usage{
mseEr(y, k, h, type)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}

\item{type}{mention distribution of vector.If exponential distribution then use \code{"Exp"}.
if use gamma distribution then use \code{"Gamma"}.If Weibull distribution then use \code{"Weibull"}.}
}
\value{
MSE
}
\description{
Calculate MSE by using Erlang Kernel.
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
mseEr(y,200,h,"Exp")
}
\references{
Salha, R. B.; Ahmed, E. S.; Alhoubi, I. M. 2014. Hazard rate function estimation ksing Erlang Kernel. \emph{Pure Mathematical Sciences} \strong{3} (4), 141–152.
}
\seealso{
For further MSE by using other kernels see \code{\link{mseBS}}, \code{\link{mseLN}} and \code{\link{mseGamma}}. For estimated values for density estimation \code{\link{Erlang}} and for density estimation by using Erlang Kernel \code{\link{plot.Erlang}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
