\name{p.val}
\alias{p.val}
\title{Bootstrap Test of Significance}
\description{
This function gives the significance level for an empirical
value to be significantly larger than a distribution of bootstrapped
values.
}
\usage{
p.val(empirical.value, bootstrapped.values)
}
\arguments{
\item{empirical.value}{The test statistic that is obtained from the
    empirical data.}

\item{bootstrapped.values}{A vector of test statistics obtained from a
    bootstrap method (i.e. resampling with replacement). Bootstrap
    values of genetic differentiation measurements for example can be
    generated by the functions described in the help file
    \code{\link{Bootstrapping.D}}.}
}
\value{
A p-value giving an estimate of the probability that the
empirical value or a value more extreme than this could have occurred by
chance, if the null hypothesis were true.

  The calculated 'p.value' is assigned to the workspace (.GlobalEnv).
}
\details{
Since the empirical value
    of genetic differentiation is expected to be larger than a value
    obtained from within a panmictic population when the tested
    populations are significantly differentiated, a one tailed test is
    carried out. The empirical value is significantly large at the 95\%
    level if it is one of the largest 5\% of the test statistics (the
    bootstrapped ones and the empirical one). It is calculated according
    to Manly (1997, p. 62).
  
}
\references{
Manly, B. F. J. 1997 \emph{Randomization, Bootstrap and
Monte Carlo Methods in Biology}. Chapman & Hall
}
\note{This function is a fragment used by other functions of this
  package. The following functions carry out the appropriate
  calculations automatically to obtain data tables
  listing measures of genetic differentiation between populations with
  95\% confidence intervals and p-values from a data table containing
  allelic data: \code{\link{all.pops.D}}, \code{\link{all.pops.Dest}},
  \code{\link{all.pops.Dest.Chao}}, \code{\link{all.pops.Gst}}, \code{\link{all.pops.Gst.est}},
  \code{\link{pair.pops.D}}, \code{\link{pair.pops.Dest}}, \code{\link{pair.pops.Dest.Chao}},
  \code{\link{pair.pops.Gst}}, \code{\link{pair.pops.Gst.est}}.}
\seealso{
\code{\link{Bootstrapping.D}},
  \code{\link{allelefreq}},
  \code{\link{Dest.calc}},
  \code{\link{p.value.correcture}},
  \code{\link{all.pops.Dest}},
  \code{\link{all.pops.Dest.Chao}},
  \code{\link{all.pops.Gst}},
  \code{\link{all.pops.Gst.est}},
  \code{\link{pair.pops.Dest}},
  \code{\link{pair.pops.Dest.Chao}},
  \code{\link{pair.pops.Gst}},
  \code{\link{pair.pops.Gst.est}}
}
\examples{
data(Example.transformed)
Example1 <- Example.transformed
Bootstrapping.Dest(Example1,bt=10)

# 10 bootstrap values are created. This is not enough to test real data
# but avoids long calculation time in this example.

allelefreq(Example1)

# The allelefrequencies as well as the sample sizes
# are calculated.

Dest.calc(allelefrequency, sample.sizes)

# The empirical Dest values
# for each locus and over all loci are calculated.

p.val(D.values$Mean.Dest.value,Dest.means)

p.value
}
\author{
Alexander Jueterbock, \email{Alexander-Jueterbock@web.de};
Philipp Kraemer, \email{philipp.kraemer@uni-oldenburg.de}
}
\keyword{htest}
