\name{IprNcdif}
\alias{IprNcdif}
\title{NCDIF for Item parameter replication}
\usage{
IprNcdif(itemParameterList, irtModel = "2pl", focalAbilities = NULL,
  focalDistribution = "norm", subdivisions = 5000, logistic = TRUE,
  focalDistrExtra = list(mean = 0, sd = 1))
}
\arguments{
  \item{itemParameterList}{A list where each element is a
  list containing "focal" and "reference" item Parameters.
  Item parameters are assumed to be on the same scale. Item
  parameters for each group should be a matrix with nrow
  equal to the number of items.}

  \item{irtModel}{A string stating the irtModel to be used.
  Should be one of "1pl", "2pl", "3pl", "grm" or "pcm".}

  \item{focalAbilities}{If NULL, NCDIF is calculated by
  numerical integration of focal distribution. If not NULL,
  must be a numerical vector containing the abilities for
  the individuals in the focal group.}

  \item{focalDistribution}{A string stating the
  distribution name to be used for integrating. Only used
  if focalAbilities is NULL.}

  \item{focalDistrExtra}{A list stating the extra
  parameters needed by the focal distribution function.}

  \item{subdivisions}{A numeric value indicating the number
  of subdivisions for numerical integration. Only used if
  focalAbilities is NULL.}

  \item{logistic}{A logical value stating if the IRT model
  will use the logistic or the normal metric. Defaults to
  using the logistic metric by fixing the D constant to 1.
  If FALSE the constant is set to 1.702 so that the normal
  metric is used.}
}
\value{
ncdif A numeric matrix with the NCDIF values for all the
item parameter in each set of itemParameterList
}
\description{
Calculates the NCDIF index on a list of item parameters
such as those produced by the Ipr function
}
\examples{
# # Not run
# #
# # data(dichotomousItemParameters)
# # threePlAse <- list()
# # threePlAse[['focal']] <- AseIrt(itemParameters = dichotomousItemParameters[['focal']],
# #                                 logistic = TRUE, sampleSize = 500, irtModel = '3pl')
# # threePlAse[['reference']] <- AseIrt(itemParameters = dichotomousItemParameters[['reference']],
# #                                     logistic = TRUE, sampleSize = 500, irtModel = '3pl')
# # threePlIpr <- Ipr(itemParameters = dichotomousItemParameters, itemCovariances = threePlAse,
# #                   nReplicates = 1000)
# # threePlNcdifIpr <- IprNcdif(itemParameterList = threePlIpr, irtModel = '3pl', logistic = TRUE)
}
\author{
Victor H. Cervantes <vcervantes at icfes.gov.co>
<vhcervantesb at unal.edu.co>
}
\references{
Oshima, T., Raju, N. & Nanda, A. (2006). A new method for
assessing the statistical significance in the Differential
Functioning of Items and Tests (DFIT) framework. Journal of
educational measurement, 43(1), 1--17.
}

