% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addItem.R
\name{addItem}
\alias{addItem}
\title{Add a data item}
\usage{
addItem(
  dgeObj,
  item,
  itemName,
  itemType,
  funArgs = match.call(),
  itemAttr,
  parent = "",
  overwrite = FALSE,
  init = FALSE
)
}
\arguments{
\item{dgeObj}{A class DGEobj created by function initDGEobj()}

\item{item}{The data item to be deposited in the DGEobj}

\item{itemName}{The user-assigned name for this data item}

\item{itemType}{The type attribute.  See showTypes() to see the predefined types -- types are extensible with the newType() function.}

\item{funArgs}{(optional) A text field to annotate how the data object was created. If the result of match.call() is passed as this argument, the name and arguments used in the current function are captured}

\item{itemAttr}{(optional) A named list of attributes to add directly to the item}

\item{parent}{(optional) itemName of the parent of this item}

\item{overwrite}{Whether to overwrite a matching data object stored in the itemName slot (default = FALSE)}

\item{init}{Internal Use (default = FALSE)}
}
\value{
A DGEobj
}
\description{
Add a data item
}
\examples{
\dontrun{
   myFunArgs <- match.call()  #  Capture calling function and arguments

   myDGEobj <- addItem(myDGEobj, item = MyCounts,
                                 itemName = "counts",
                                 itemType = "counts",
                                 funArgs = myFunArgs)
}

}
