% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{newType}
\alias{newType}
\title{Add a new type definition to a DGEobj}
\usage{
newType(dgeObj, itemType, baseType, uniqueItem = FALSE)
}
\arguments{
\item{dgeObj}{A class DGEobj created by function initDGEobj()}

\item{itemType}{The name of the new type to create}

\item{baseType}{The baseType of the new item. One of [row, col, assay, meta]}

\item{uniqueItem}{If set to TRUE, only one instance of the new type is allowed in a DGEobj}
}
\value{
A DGEobj
}
\description{
Add a new type definition to a DGEobj
}
\examples{
    # example DGEobj
    exObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    exObj <- newType(exObj,
                     itemType   = "AffyRMA",
                     baseType   = "assay",
                     uniqueItem = TRUE)

}
