% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chmort.R
\name{chmort}
\alias{chmort}
\title{Calculates childhood mortality rates based on the Demographic and Health Surveys (DHS).}
\usage{
chmort(Data.Name, JK = NULL, Strata = NULL, Cluster = NULL,
  Weight = NULL, Year_of_survey = NULL, Date_of_interview = NULL,
  Date_of_birth = NULL, Date_of_death = NULL, PeriodEnd = NULL,
  Period = NULL, Class = NULL)
}
\arguments{
\item{Data.Name}{DHS data birth files (BR).}

\item{JK}{"Yes" to estimate Jackknife SE.}

\item{Strata}{The stratification variable name if other than "v022".}

\item{Cluster}{The sampling clusters variable name if other than "v021".}

\item{Weight}{The sampling weight variable name if other than "v005".}

\item{Year_of_survey}{Year of survey variable if other than "v007".}

\item{Date_of_interview}{Date of Interview variable if other than "v008".}

\item{Date_of_birth}{Child date of birth variable if other than "b3".}

\item{Date_of_death}{Child date of death variable if other than "b7".}

\item{PeriodEnd}{The end year of the exposure period; default is the year of the survey.}

\item{Period}{The study period for mortality; default is 5 years.}

\item{Class}{Allow for domain level indicators.}
}
\value{
Childhood mortality rates (NNMR, PNNMR, IMR, CMR and U5MR), and precision indicators (SE, RSE and CI).
}
\description{
\code{chmort} returns childhood mortality rates such as Neonatal Mortality Rate (NNMR),
Post-neonatal Mortality Rate (PNNMR), Infant Mortality Rate (IMR), Child Mortality Rate (CMR),
and Under-5 Mortality Rate (U5MR)
\code{chmort} returns the Standrad Error (SE), Number of births contributed to the death exposure (N),
the Relative Standard Error (RSE) and the Confidence Interval (CI).
}
\examples{
# Calculate five-year children mortality rates based on ADBR70 data

data("ADBR70")
chmort(
 ADBR70,
 JK = "Yes"
)

# Calculate ten-year children mortality rates based on ADBR70 data

data("ADBR70")
chmort(
 ADBR70,
 JK = "Yes",
 Period = 10
)

# The exposure period ends in 2011

data("ADBR70")
chmort(
 ADBR70,
 PeriodEnd = 2011
)

}
\author{
Mahmoud Elkasabi.
}
