% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIFtree.R
\name{DIFtree}
\alias{DIFtree}
\alias{print.DIFtree}
\title{Item Focused Trees for the Identification of Items in Differential Item Functioning}
\usage{
DIFtree(Y, X, model = c("Rasch", "Logistic"), type = "udif", alpha, nperm,
  trace = FALSE, penalize = FALSE, ...)

\method{print}{DIFtree}(x, ...)
}
\arguments{
\item{Y}{Matrix or Data.frame of binary 0/1 response (rows correspond to persons, columns correspond to items)}

\item{X}{Data.frame of (not scaled) covariates (rows correspond to persons, columns correspond to covariates)}

\item{model}{Type of model to be fitted; can be \code{"Rasch"} or \code{"Logistic"}.}

\item{type}{Type of DIF to be modelled; one out of \code{"udif"}, \code{"dif"} and \code{"nudif"}. 
For \code{"Rasch"} model only uniform DIF can be modelled and therefore \code{type} will be ignored.}

\item{alpha}{Global significance level for the permutation tests}

\item{nperm}{Number of permutations used for the permutation tests}

\item{trace}{If true, information about the estimation progress is printed}

\item{penalize}{If true, a small ridge penalty is added to ensure existence of model parameters; only for \code{"Rasch"} model.}

\item{x}{Object of class \code{"DIFtree"}}

\item{...}{Further arguments passed to or from other methods}
}
\value{
Object of class \code{"DIFtree"}. 
An object of class \code{"DIFtree"} is a list containing the following components:

\item{splits}{Matrix with detailed information about all executed splits during the estimation process}
\item{coefficients}{List of estimated coefficients for items with and without DIF. 
Structure of \code{coefficients} depends on \code{model} and \code{type}.}
\item{pvalues}{P-values of each permutation test during the estimation process}
\item{devs}{Maximal value statistics \eqn{T_j} of selected variable of each iteration during the estimation process}
\item{crit}{Critical values of each permutation test during the estimation process}
\item{Y}{Response matrix used in the estimation process}
\item{X}{Model matrix used in the estimation process}
\item{persons}{Number of persons} 
\item{items}{Number of items}
}
\description{
A function to estimate item focused trees for simultaneous selection of items and variables 
that induce DIF (Differential Item Functioning) based on the Rasch Model or the 
Logistic Regression Approach for DIF detection.
The basic method of item focussed recursive partitioning in Rasch Models is described in Tutz and Berger (2015).
}
\details{
The methods require 0/1 coded answers on binary items. 
Items with DIF are gradually identified by recursive partitioning.

For \code{"Rasch"} model one yields a model with linear predictors 
\deqn{eta_{pi}=theta_p-tr_i(x_p),}
where \eqn{theta_p} correspond to the ability and \eqn{x_p} correspond to the covariate vector of person p. 

For \code{"Logistic"} model one yields a model with linear predictors 
\itemize{
\item Uniform DIF, \code{type="udif"}
\deqn{eta_{pi}=S_p beta_i+tr_i(x_p),}
where \eqn{S_p} corresponds to the test score and \eqn{x_p} corresponds to the covariate vector of person p.
\item DIF and Non-Uniform DIF, \code{type="dif", "nudif"}
\deqn{eta_{pi}=tr_i(x_p)+tr_i(S_p,x_p),}
where \eqn{S_p} corresponds to the test score and \eqn{x_p} corresponds to the covariate vector of person p. 
}
 

Significance of each split is verified by permutation tests. The result of the permutation tests 
can strongly depend on the number of permutations \code{nperm}.
In the case of pure terminal nodes estimates of the model do not exist. If \code{penalize=TRUE} 
a small ridge penalty is added during estimation to ensure existence of all parameters.
}
\examples{
data(data_sim)
 
Y <- data_sim[,1]
X <- data_sim[,-1]
 
\dontrun{
 
mod <- DIFtree(Y=Y,X=X,model="Logistic",type="udif",alpha=0.05,nperm=1000,trace=TRUE)
 
print(mod)
}

}
\author{
Moritz Berger <moritz.berger@stat.uni-muenchen.de> \cr \url{http://www.statistik.lmu.de/~mberger/}
}
\references{
Berger, Moritz and Tutz, Gerhard (2015): Detection of Uniform and Non-Uniform Differential Item Functioning 
by Item Focussed Trees, Cornell University Library, arXiv:1511.07178

Swaminathan, Hariharan and Rogers, H Jane (1990): Detecting differential item functioning 
using logistic regression procedures, Journal of Educational measurements 27(4), 361-370

Tutz, Gerhard and Berger, Moritz (2015): Item Focused Trees for the Identification of Items
in Differential Item Functioning, Psychometrika, published online, DOI: 10.1007/s11336-015-9488-3
}
\seealso{
\code{\link[DIFtree]{plot.DIFtree}}, \code{\link[DIFtree]{predict.DIFtree}}, \code{\link[DIFtree]{summary.DIFtree}}
}

