% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSLMI.R
\name{CSLMI}
\alias{CSLMI}
\title{CSLMI: Consensus-based Stochastic Linear Multiple Imputation (Simplified Version)}
\usage{
CSLMI(data, M)
}
\arguments{
\item{data}{Dataframe with response variable in 1st column and predictors in others}
\item{M}{Number of imputations}}
\value{
A list containing:
  \item{Yhat}{Matrix of size n x M with imputed response values.}
  \item{betahat}{Average regression coefficients across imputations.}
  \item{comm}{Communication cost (number of messages passed).}
}
\description{
Performs multiple imputation and parameter estimation using a consensus-based approach.
It assumes:
  - The response variable is in the first column
  - All other columns are predictors
  - Missing values are automatically detected
  - The whole dataset is treated as one block
}
\examples{
set.seed(123)
data <- data.frame(
  y = c(rnorm(50), rep(NA, 10)),
  x1 = rnorm(60),
  x2 = rnorm(60)
)
result <- CSLMI(data = data, M = 10)
head(result$Yhat)
print(result$betahat)
print(result$comm)
}
