% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCSLMI.R
\name{DCSLMI}
\alias{DCSLMI}
\title{Distributed and Consensus-Based Stochastic Linear Multiple Imputation (DCSLMI)}
\usage{
DCSLMI(data, R = 1000, M = 20)
}
\arguments{
\item{data}{A data frame or matrix. The first column contains the response variable `y`
(which may include NA values), and the remaining columns are predictors `X`.}

\item{R}{Number of internal iterations for parameter estimation per imputation.}

\item{M}{Number of multiple imputations to generate.}
}
\value{
A list containing:
\describe{
  \item{Yhat}{A matrix of size n x M, where each column is a completed response vector.}
  \item{betahat}{A matrix of size (p+1) x M, where each column contains the estimated regression coefficients.}
  \item{missing_count}{The number of missing values in the original response variable.}
}
}
\description{
Performs multiple imputation for missing response variables in linear regression models.
This method iteratively updates parameter estimates using ordinary least squares (OLS)
and generates M complete datasets by imputing missing values with different parameter draws.
}
\examples{
# Simulate data with missing responses
set.seed(123)
data <- data.frame(
  y = c(rnorm(50), rep(NA, 10)),
  x1 = rnorm(60),
  x2 = rnorm(60)
)

# Perform multiple imputation
result <- DCSLMI(data, R = 500, M = 10)

# View imputed response values
head(result$Yhat)

# View coefficient estimates
apply(result$betahat, 1, mean)  # average estimates
apply(result$betahat, 1, sd)    # uncertainty across imputations

}
