% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMRE.R
\name{EMRE}
\alias{EMRE}
\title{EM Algorithm for Linear Regression with Missing Data}
\usage{
EMRE(data, d = 1, tol = 1e-06, nb = 100, niter = 1)
}
\arguments{
\item{data}{Dataframe with first column as response (Y) and others as predictors (X)}

\item{d}{Initial convergence threshold (default=1)}

\item{tol}{Termination tolerance (default=1e-6)}

\item{nb}{Maximum iterations (default=100)}

\item{niter}{Starting iteration counter (default=1)}
}
\value{
List containing:
\item{Yhat}{Imputed response vector}
\item{betahat}{Estimated coefficients}
}
\description{
EM Algorithm for Linear Regression with Missing Data
}
\examples{
# Generate data with 20\% missing Y values
set.seed(123)
data <- data.frame(Y=c(rnorm(80),rep(NA,20)), X1=rnorm(100), X2=rnorm(100))

# Run EM algorithm
result <- EMRE(data, d=1, tol=1e-5, nb=50)
print(result$betahat) # View coefficients
}
