% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineClasses.r
\docType{class}
\name{Imp-class}
\alias{Imp-class}
\title{Class \code{'Imp'}}
\description{
An operating model component that specifies the degree of adherence to management recommendations (Implementation error)
}
\section{Slots}{

\describe{
\item{\code{Name}}{The name of the Implementation error object. Single value. Character string.}

\item{\code{TACFrac}}{Mean fraction of TAC taken. Uniform distribution lower and upper bounds. Positive real number.}

\item{\code{TACSD}}{Log-normal coefficient of variation in the fraction of Total Allowable Catch (TAC) taken. Uniform distribution lower and upper bounds. Non-negative real numbers.}

\item{\code{TAEFrac}}{Mean fraction of TAE taken. Uniform distribution lower and upper bounds. Positive real number.}

\item{\code{TAESD}}{Log-normal coefficient of variation in the fraction of Total Allowable Effort (TAE) taken. Uniform distribution lower and upper bounds. Non-negative real numbers.}

\item{\code{SizeLimFrac}}{The real minimum size that is retained expressed as a fraction of the size. Uniform distribution lower and upper bounds. Positive real number.}

\item{\code{SizeLimSD}}{Log-normal coefficient of variation controlling mismatch between a minimum size limit and the real minimum size retained. Uniform distribution lower and upper bounds. Non-negative real numbers.}

\item{\code{Source}}{A reference to a website or article form which parameters were taken to define the object. Single value. Character string.}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('Imp')}
}

\examples{

showClass('Imp')

}
\author{
T. Carruthers and A. Hordyk
}
\keyword{classes}
