% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Output.R
\name{AvC}
\alias{AvC}
\title{Average Catch}
\usage{
AvC(x, Data, reps = 100)
}
\arguments{
\item{x}{A position in a data-limited methods data object}

\item{Data}{A data-limited methods data object}

\item{reps}{The number of stochastic samples of the TAC recommendation}
}
\description{
A simple average catch MP that is included to demonstrate a 'status quo' management option
}
\examples{
Data <- DLMtool::Cobia
# Plot the historical catches 
plot(Data@Year, Data@Cat[1,], type="l", 
     xlab="Year", ylab=paste0("Catch (", Data@Units, ")"), lwd=2)
abline(h=mean(Data@Cat[1,]), lty=2) # plot mean catches

# Apply the AvC MP to the Data
Rec <- AvC(1, Data, reps=1000) # 1,000 log-normal samples with CV = 0.2

# Distribution of TACs
boxplot(Rec@TAC, add=TRUE, at=max(Data@Year), col="grey", 
        width=1, outline=FALSE)
        
}
\author{
T. Carruthers
}
