% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StochasticSRA.R
\name{LSRA_opt}
\alias{LSRA_opt}
\title{Internal estimation function for LSRA and LSRA2 functions}
\usage{
LSRA_opt(param, FF_a, Chist, M_a, Mat_age_a, Wt_age_a, sel_a, Recdevs_a, h_a,
  Umax = 0.5, mode = 1)
}
\arguments{
\item{param}{a numeric value representing log(R0)}

\item{FF_a}{numeric value, recent fishign mortality rate (apical F)}

\item{Chist}{a vector of historical catch observations \code{[nyears]}}

\item{M_a}{numeric value, natural mortality rate}

\item{Mat_age_a}{a vector of maturity at age \code{[nage]}}

\item{Wt_age_a}{a vector of weight at age \code{[nage]}}

\item{sel_a}{a vector of selectivity at age \code{[nage]}}

\item{Recdevs_a}{a vector of recruitment deviations \code{[nyears]}}

\item{h_a}{a numeric value of steepness values of the Bev-Holt Stock-Recruitment relationship}

\item{Umax}{maximum harvest rate per year}

\item{mode}{1-5 see below}
}
\value{
depends on mode but could be 1:objective function 2:trajectory of Fs 3: SSB depletion 4:log(R0) 5:diagnostic plots
}
\description{
Internal estimation function for LSRA and LSRA2 functions
}
\author{
T. Carruthers
}
