% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dmcfit}
\alias{plot.dmcfit}
\title{plot.dmcfit: Plot observed + fitted data}
\usage{
\method{plot}{dmcfit}(
  x,
  y,
  subject = NULL,
  figType = "summary",
  legend = TRUE,
  labels = c("Compatible", "Incompatible", "Observed", "Predicted"),
  cols = c("black", "green", "red"),
  ylimRt = c(200, 800),
  ylimEr = c(0, 20),
  ylimCAF = c(0, 1),
  cafBinLabels = FALSE,
  ylimDelta = c(-50, 100),
  xlimDelta = c(200, 1000),
  xlabs = TRUE,
  ylabs = TRUE,
  xaxts = TRUE,
  yaxts = TRUE,
  resetPar = TRUE,
  ...
)
}
\arguments{
\item{x}{Output from dmcFit}

\item{y}{Observed data}

\item{subject}{NULL (aggregated data across all subjects) or integer for subject number}

\item{figType}{summary, rtCorrect, errorRate, rtErrors, cdf, caf, delta, all}

\item{legend}{TRUE/FALSE (or FUNCTION) plot legend on each plot}

\item{labels}{Condition labels c("Compatible", "Incompatible", "Observed", "Predicted") default}

\item{cols}{Condition colours c("green", "red") default}

\item{ylimRt}{ylimit for Rt plots}

\item{ylimEr}{ylimit for error rate plots}

\item{ylimCAF}{ylimit for CAF plot}

\item{cafBinLabels}{TRUE/FALSE}

\item{ylimDelta}{ylimit for delta plot}

\item{xlimDelta}{xlimit for delta plot}

\item{xlabs}{TRUE/FALSE}

\item{ylabs}{TRUE/FALSE}

\item{xaxts}{TRUE/FALSE}

\item{yaxts}{TRUE/FALSE}

\item{resetPar}{TRUE/FALSE Reset graphical parameters}

\item{...}{additional plot pars}
}
\description{
Plot the simulation results from the output of dmcFit. The plot
can be an overall summary, or individual plots (activation, trials, pdf, cdf,
caf, delta, all). Plot type summary1 contains an activation plot, example
individual trials, the probability distribution function (PDF), the cumulative
distribution function (CDF), the conditional accuracy function (CAF) and
delta plots. This required that dmcSim is run with fullData = TRUE. Plot type
summary2 contains only the PDF, CDF, CAF and delta plots and does not require
that dmcSim is run with fullData = TRUE.
}
\examples{
\donttest{
# Example 1
resTh <- dmcFit(flankerData, nTrl = 5000)
plot(resTh, flankerData)

# Example 2
resTh <- dmcFit(flankerData, nTrl = 5000)
plot(resTh, flankerData)
plot(resTh, flankerData, figType = "all")

# Example 3
resTh <- dmcFit(simonData, nTrl = 5000)
plot(resTh, simonData)
}

}
