% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{calculateCostValueSPE}
\alias{calculateCostValueSPE}
\title{calculateCostValueSPE: Calculate squared percentage error (SPE) from RT and error data}
\usage{
calculateCostValueSPE(resTh, resOb)
}
\arguments{
\item{resTh}{list containing caf values for comp/incomp conditions (nbins * 4 columns) and
delta values for comp/incomp conditions (nbins * 5 columns). See output from dmcSim (.$caf).}

\item{resOb}{list containing caf values for comp/incomp conditions (n * 4 columns) and
delta values for comp/incomp conditions (nbins * 5 columns). See output from dmcSim (.$delta).}
}
\value{
cost value (SPE)
}
\description{
Calculate cost value (fit) from combination of RT and error rate.
}
\examples{
# Example 1:
resTh <- dmcSim()
resOb <- dmcSim()
cost <- calculateCostValueSPE(resTh, resOb)

# Example 2:
resTh <- dmcSim()
resOb <- dmcSim(tau = 150)
cost <- calculateCostValueSPE(resTh, resOb)
}
