% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.DMRnet.R
\name{cv.DMRnet}
\alias{cv.DMRnet}
\title{cross-validation for DMRnet}
\usage{
cv.DMRnet(
  X,
  y,
  family = "gaussian",
  clust.method = "complete",
  o = 5,
  nlambda = 20,
  lam = 10^(-7),
  interc = TRUE,
  maxp = ifelse(family == "gaussian", ceiling(length(y)/2), ceiling(length(y)/4)),
  nfolds = 10,
  indexation.mode = "GIC",
  algorithm = "DMRnet"
)
}
\arguments{
\item{X}{Input data frame, of dimension n x p; each row is an observation vector. Columns can be numerical or integer for continuous predictors or factors for categorical predictors.}

\item{y}{Response variable. Numerical for \code{family="gaussian"} or a factor with two levels for \code{family="binomial"}. For \code{family="binomial"} the last level in alphabetical order is the target class.}

\item{family}{Response type; one of: \code{"gaussian"}, \code{"binomial"}.}

\item{clust.method}{Clustering method used for partitioning levels of factors; see function \href{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/hclust.html}{hclust} in package \pkg{stats} for details. \code{clust.method="complete"} is the default.}

\item{o}{Parameter of the group lasso screening step, described in \code{\link{DMRnet}}.}

\item{nlambda}{Parameter of the group lasso screening step, described in \code{\link{DMRnet}}.}

\item{lam}{The amount of penalization in ridge regression (used for logistic regression in order to allow for parameter estimation in linearly separable setups) or the amount of matrix regularization in case of linear regression. Used only for numerical reasons. The default is 1e-7.}

\item{interc}{Should intercept(s) be fitted (the default, \code{interc=TRUE}) or set to zero (\code{interc=FALSE}). If in \code{X} there are any categorical variables, \code{interc=TRUE} must be set.}

\item{maxp}{Maximal number of parameters of the model, smaller values result in quicker computation.}

\item{nfolds}{Number of folds in cross-validation. The default value is 10.}

\item{indexation.mode}{How the cross validation algorithm should index the models for internal quality comparisons; one of: \code{"GIC"} (the default) for GIC-indexed cross validation, \code{"dimension"}, for model dimension-indexed cross validation.}

\item{algorithm}{The algorithm to be used to merge levels; one of: \code{"DMRnet"} (the default), \code{"glamer"}.}
}
\value{
An object with S3 class "cv.DMR" is  returned,  which  is  a  list  with  the  ingredients  of  the  cross-validation fit.
\describe{
  \item{df.min}{df (number of parameters) of the model with minimal cross-validated error.}
  \item{df.1se}{df (number of parameters) of the smallest model falling under the upper curve of a prediction error plus one standard deviation. Only for the indexation.mode equal to \code{"dimension"}, otherwise it is set to \code{NULL}.}
  \item{dmr.fit}{Fitted \code{DMR} object for the full data.}
  \item{cvm}{The mean cross-validated error for the entire sequence of models.}
  \item{foldid}{The fold assignments used.}
}
}
\description{
Does k-fold cross-validation for DMR and returns a value for df.
}
\details{
cv.DMRnet algorithm does \code{nfold}-fold cross-validation for DMRnet. The df for the minimal estimated prediction error is returned.
}
\examples{
## cv.DMRnet for linear regression
set.seed(13)
data(miete)
ytr <- miete$rent[1:1500]
Xtr <- miete$area[1:1500]
Xte <- miete$area[1501:2053]
cv <- cv.DMRnet(Xtr, ytr)
print(cv)
plot(cv)
coef(cv)
ypr <- predict(cv, newx = Xte)

}
\seealso{
\code{\link{plot.cv.DMR}} for plotting, \code{\link{coef.cv.DMR}} for extracting coefficients and \code{\link{predict.cv.DMR}} for prediction.
}
