% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pr_next_allele.R
\name{pr.next.alleles}
\alias{pr.next.alleles}
\title{Probability of seeing next alleles (Dirichlet sampling)}
\usage{
pr.next.alleles(ij, seen, fr, theta = 0)
}
\arguments{
\item{ij}{integer matrix with allele numbers}

\item{seen}{integer matrix with alleles already seen}

\item{fr}{numeric vector with allelic proportions}

\item{theta}{numeric background relatedness}
}
\value{
numeric (vector) of probabilities
}
\description{
Probability of seeing next alleles (Dirichlet sampling)
}
\details{
When a population is subdivided into subpopulations, consecutively sampled alleles are not independent draws. This function implements the Dirichlet formula which states that after sampling \eqn{n} alleles, of which \eqn{m} are of type \eqn{A_i}, the probability that the next allele is of type \eqn{A_i} equals:

\eqn{(m*\theta+(1-\theta)*p_i)/(1+(n-1)*\theta)}

The alleles already sampled are passed as the rows of the matrix \code{seen}, while the corresponding row of \code{ij} specifies for which alleles the probability of sampling is computed. The numer of rows of \code{ij} has to be equal to the number of rows of \code{seen}.
}
\examples{
# compute the pr. of seeing 1,1 after 1,1,1,1
# when theta=0 this is simply p_1^2
pr.next.alleles(t(c(1,1)),seen=t(c(1,1,1,1)),fr=c(1/4,3/4),theta=0)
# but when theta>0, the pr. of seeing more 1's increases slightly
pr.next.alleles(t(c(1,1)),seen=t(c(1,1,1,1)),fr=c(1/4,3/4),theta=0.05)

# pr. distribution of (ordered!) genotypes after seeing 1,1,1
ij=matrix(c(1,1,1,2,2,2),ncol=2,byrow=TRUE)
seen=matrix(1,nrow=3,ncol=3,byrow=TRUE)
pr.next.alleles(ij,seen,fr=c(1/4,3/4),theta=0) # theta=0
pr.next.alleles(ij,seen,fr=c(1/4,3/4),theta=0.1) # theta=0.1

p0 <- pr.next.alleles(ij,seen,fr=c(1/4,3/4),theta=0)
stopifnot(all.equal(p0[1]+2*p0[2]+p0[3],1))

p1 <- pr.next.alleles(ij,seen,fr=c(1/4,3/4),theta=0.05)
stopifnot(all.equal(p1[1]+2*p1[2]+p1[3],1))
}
\seealso{
\code{\link{pr.next.allele}}, \code{\link{rmp}}
}

