% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatFunctions.R
\name{medianDP}
\alias{medianDP}
\title{Differentially Private Median}
\usage{
medianDP(
  x,
  eps,
  lower.bound,
  upper.bound,
  which.sensitivity = "bounded",
  mechanism = "exponential",
  uniform.sampling = TRUE
)
}
\arguments{
\item{x}{Numeric vector of which the median will be taken.}

\item{eps}{Positive real number defining the epsilon privacy budget.}

\item{lower.bound}{Real number giving the global or public lower bound of x.}

\item{upper.bound}{Real number giving the global or public upper bound of x.}

\item{which.sensitivity}{String indicating which type of sensitivity to use.
Can be one of \{'bounded', 'unbounded', 'both'\}. If 'bounded' (default),
returns result based on bounded definition for differential privacy. If
'unbounded', returns result based on unbounded definition. If 'both',
returns result based on both methods \insertCite{Kifer2011}{DPpack}. Note
that if 'both' is chosen, each result individually satisfies (eps,
0)-differential privacy, but may not do so collectively and in composition.
Care must be taken not to violate differential privacy in this case.}

\item{mechanism}{String indicating which mechanism to use for differential
privacy. Currently the following mechanisms are supported: \{'exponential'\}.
See \code{\link{ExponentialMechanism}} for a description of the supported
mechanisms.}

\item{uniform.sampling}{Boolean indicating whether to sample uniformly
between sorted dataset values when returning the private quantile. If TRUE,
it is possible for this function to return any number between lower.bound
and upper.bound. If FALSE, only a value present in the dataset or the lower
bound can be returned.}
}
\value{
Sanitized median based on the bounded and/or unbounded definitions
of differential privacy.
}
\description{
This function computes the differentially private median of an input vector
at a user-specified privacy level of epsilon.
}
\examples{
D <- stats::rnorm(500)
lower.bound <- -3 # 3 standard deviations below mean
upper.bound <- 3 # 3 standard deviations above mean

eps <- 1
# Get median satisfying pure 1-differential privacy
private.median <- medianDP(D, eps, lower.bound, upper.bound)
private.median

# Require released value to be in dataset
private.median <- medianDP(c(1,0,3,3,2), eps, 0, 4, uniform.sampling = FALSE)
private.median

}
\references{
\insertRef{Dwork2006a}{DPpack}

\insertRef{Kifer2011}{DPpack}

\insertRef{Smith2011a}{DPpack}
}
