% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twfe_did_panel.R
\name{twfe_did_panel}
\alias{twfe_did_panel}
\title{Two-way fixed effects DiD estimator, with panel data}
\usage{
twfe_did_panel(
  y1,
  y0,
  D,
  covariates,
  i.weights = NULL,
  boot = FALSE,
  boot.type = "weighted",
  nboot = NULL,
  inffunc = FALSE
)
}
\arguments{
\item{y1}{An \eqn{n} x \eqn{1} vector of outcomes from the post-treatment period.}

\item{y0}{An \eqn{n} x \eqn{1} vector of outcomes from the pre-treatment period.}

\item{D}{An \eqn{n} x \eqn{1} vector of Group indicators (=1 if observation is treated in the post-treatment, =0 otherwise).}

\item{covariates}{An \eqn{n} x \eqn{k} matrix of covariates to be used in the regression estimation.}

\item{i.weights}{An \eqn{n} x \eqn{1} vector of weights to be used. If NULL, then every observation has the same weights. The weights are normalized and therefore enforced to have mean 1 across all observations.}

\item{boot}{Logical argument to whether bootstrap should be used for inference. Default is FALSE.}

\item{boot.type}{Type of bootstrap to be performed (not relevant if \code{boot = FALSE}). Options are "weighted" and "multiplier".
If \code{boot = TRUE}, default is "weighted".}

\item{nboot}{Number of bootstrap repetitions (not relevant if \code{boot = FALSE}). Default is 999.}

\item{inffunc}{Logical argument to whether influence function should be returned. Default is FALSE.}
}
\value{
A list containing the following components:
 \item{ATT}{The TWFE DiD point estimate}
 \item{se}{The TWFE DiD standard error}
 \item{uci}{Estimate of the upper bound of a 95\% CI for the TWFE parameter.}
 \item{lci}{Estimate of the lower bound of a 95\% CI for the TWFE parameter.}
 \item{boots}{All Bootstrap draws of the ATT, in case bootstrap was used to conduct inference. Default is NULL}
 \item{att.inf.func}{Estimate of the influence function. Default is NULL}
}
\description{
\code{twfe_did_panel} is used to compute linear two-way fixed effects estimators for the ATT
 in difference-in-differences (DiD) setups with panel data. As illustrated by Sant'Anna and Zhao (2020),
 this estimator generally do not recover the ATT. We encourage empiricists to adopt alternative specifications.
}
\examples{
# Form the Lalonde sample with CPS comparison group
eval_lalonde_cps <- subset(nsw, nsw$treated == 0 | nsw$sample == 2)
# Further reduce sample to speed example
set.seed(123)
unit_random <- sample(1:nrow(eval_lalonde_cps), 5000)
eval_lalonde_cps <- eval_lalonde_cps[unit_random,]
# Select some covariates
covX = as.matrix(cbind(eval_lalonde_cps$age, eval_lalonde_cps$educ,
                       eval_lalonde_cps$black, eval_lalonde_cps$married,
                       eval_lalonde_cps$nodegree, eval_lalonde_cps$hisp,
                       eval_lalonde_cps$re74))
# Implement TWFE DiD with panel data
twfe_did_panel(y1 = eval_lalonde_cps$re78, y0 = eval_lalonde_cps$re75,
               D = eval_lalonde_cps$experimental,
               covariates = covX)

}
