% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotrelp.R
\name{plotrelp}
\alias{plotrelp}
\title{Plots an object obtained with \code{relpnet}}
\usage{
plotrelp(X, rel_probs, eps_image = F)
}
\arguments{
\item{X}{- A \code{lpp} object representing a marked point pattern lying on a road network (\code{linnet} object)}

\item{rel_probs}{- An object containing the relative probabilities of a specific type of event along the linear network contained in \code{X}, generated through the function \code{relpnet}}

\item{eps_image}{- If set to \code{TRUE}, an .eps image is generated. By default it is set to \code{FALSE}}
}
\description{
This function plots the relative probability of occurrence of a type of event along a linear network
}
\examples{
library(DRHotNet)
library(spatstat.geom)
library(spatstat.linnet)
library(spdep)
\donttest{
rel_probs_rear_end <- relpnet(X = SampleMarkedPattern, 
lixel_length = 50, h = 100, mark = "Collision", category_mark = "Rear-end")
plotrelp(X = SampleMarkedPattern, rel_probs = rel_probs_rear_end)
}
}
