% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_simoutput.R
\name{generate_simoutput}
\alias{generate_simoutput}
\title{A helper function that takes result from the simulators and produces plots and text output}
\usage{
generate_simoutput(input, output, allres, varlist = NULL)
}
\arguments{
\item{input}{the shiny app input structure}

\item{output}{the shiny app output structure}

\item{allres}{multiple runs of the simulation, supplied as a list. each entry in the list is expected to be a matrix}

\item{varlist}{an optional list of vectors containing the names of variables 
that should be plotted and processed independently. if not supplied, all variables will be shown in one plot.
Also, final results for all variables will either be computed according to the groups of variable/compartment 
names provided in varlist or if not provided, all variables will be used.}
}
\value{
output a list with plot, text and warn elements for display in a shiny UI
}
\description{
This function generates plots and text to be displayed in the Shiny UI. 
This is a helper function. This function processes multiple simulation runs, supplied as a list
}
\details{
This function is called by the shiny server to produce output returned to the shiny UI
}
\author{
Andreas Handel
}
