% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_SEIRSd_model_stochastic.R
\name{simulate_SEIRSd_model_stochastic}
\alias{simulate_SEIRSd_model_stochastic}
\title{SEIRSd model}
\usage{
simulate_SEIRSd_model_stochastic(
  S = 1000,
  E = 1,
  I = 1,
  R = 0,
  bE = 0,
  bI = 0.001,
  gE = 1,
  gI = 1,
  w = 1,
  n = 0,
  m = 0,
  tstart = 0,
  tfinal = 100,
  dt = 0.1,
  rngseed = 123
)
}
\arguments{
\item{S}{: starting value for Susceptible : numeric}

\item{E}{: starting value for Exposed : numeric}

\item{I}{: starting value for Infected and Symptomatic : numeric}

\item{R}{: starting value for Recovered : numeric
Values for model parameters : numeric}

\item{bE}{: infection by exposed : numeric}

\item{bI}{: infection by symptomatic : numeric}

\item{gE}{: progression rate : numeric}

\item{gI}{: recovery rate : numeric}

\item{w}{: waning immunity : numeric}

\item{n}{: births : numeric}

\item{m}{: deaths : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}

\item{rngseed}{: set random number seed for reproducibility : numeric
Values for model times : numeric}
}
\value{
The function returns the output as a list. 
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A SEIRS model with 4 compartments
}
\details{
The model includes susceptible, exposed/asymptomatic, infected/symptomatic, and recovered compartments. The processes that are modeled are infection, progression to infectiousness, recovery and waning immunity. Demographics through natural births and deaths are also included.

This code was generated by the modelbuilder R package.  
The model is implemented as a set of stochastic equations using the adaptivetau package. 
The following R packages need to be loaded for the function to work: adpativetau 

Starting conditions for model variables
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\section{Model Author}{
 Andreas Handel
}

\section{Model creation date}{
 2020-09-28
}

\section{Code Author}{
 generated by the \code{modelbuilder} R package
}

\section{Code creation date}{
 2020-09-28
}

\examples{
 
# To run the simulation with default parameters:  
result <- simulate_SEIRSd_model_stochastic() 
# To choose values other than the standard one, specify them like this:  
result <- simulate_SEIRSd_model_stochastic(S = 2000,E = 2,I = 2,R = 0) 
# You can display or further process the result, like this:  
plot(result$ts[,'time'],result$ts[,'S'],xlab='Time',ylab='Numbers',type='l') 
print(paste('Max number of S: ',max(result$ts[,'S']))) 
}
