% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_Drug_Resistance_Evolution_stochastic.R
\name{simulate_Drug_Resistance_Evolution_stochastic}
\alias{simulate_Drug_Resistance_Evolution_stochastic}
\title{Drug Resistance Evolution}
\usage{
simulate_Drug_Resistance_Evolution_stochastic(
  S = 1000,
  Iu = 1,
  It = 1,
  Ir = 1,
  R = 0,
  bu = 0.002,
  bt = 0.002,
  br = 0.002,
  gu = 1,
  gt = 1,
  gr = 1,
  f = 0,
  cu = 0,
  ct = 0,
  tstart = 0,
  tfinal = 100,
  dt = 0.1,
  rngseed = 123
)
}
\arguments{
\item{S}{: starting value for Susceptible : numeric}

\item{Iu}{: starting value for Infected Untreated : numeric}

\item{It}{: starting value for Infected Treated : numeric}

\item{Ir}{: starting value for Infected Resistant : numeric}

\item{R}{: starting value for Recovered : numeric}

\item{bu}{: untreated infection rate : numeric}

\item{bt}{: treated infection rate : numeric}

\item{br}{: resistant infection rate : numeric}

\item{gu}{: untreated recovery rate : numeric}

\item{gt}{: treated recovery rate : numeric}

\item{gr}{: resistant recovery rate : numeric}

\item{f}{: fraction treated : numeric}

\item{cu}{: resistance emergence untreated : numeric}

\item{ct}{: resistance emergence treated : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}

\item{rngseed}{: set random number seed for reproducibility : numeric}
}
\value{
The function returns the output as a list. 
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
An SIR-type model that includes drug treatment and resistance.
}
\details{
The model includes susceptible, infected untreated, treated and resistant, and recovered compartments. The processes which are modeled are infection, treatment, resistance generation and recovery.

This code was generated by the modelbuilder R package.  
The model is implemented as a set of stochastic equations using the adaptivetau package. 
The following R packages need to be loaded for the function to work: adpativetau
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\section{Model Author}{
 Andreas Handel
}

\section{Model creation date}{
 2020-10-05
}

\section{Code Author}{
 generated by the \code{modelbuilder} R package
}

\section{Code creation date}{
 2021-02-16
}

\examples{
 
# To run the simulation with default parameters:  
result <- simulate_Drug_Resistance_Evolution_stochastic() 
# To choose values other than the standard one, specify them like this:  
result <- simulate_Drug_Resistance_Evolution_stochastic(S = 2000,Iu = 2,It = 2,Ir = 2,R = 0) 
# You can display or further process the result, like this:  
plot(result$ts[,'time'],result$ts[,'S'],xlab='Time',ylab='Numbers',type='l') 
print(paste('Max number of S: ',max(result$ts[,'S']))) 
}
